/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.internal.AbstractPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.IPartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartLists;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PagePart
extends AbstractPart
implements IPage {
    protected Object rawModel;
    protected TabFolderPart parent;

    public PagePart(TabFolderPart parent, Object rawModel) {
        super(parent.getSashWindowContainer());
        this.parent = parent;
        this.rawModel = rawModel;
    }

    protected TabFolderPart getParent() {
        return this.parent;
    }

    public void orphan() {
        if (this.garbageState == AbstractPart.GarbageState.UNVISITED) {
            this.garbageState = AbstractPart.GarbageState.ORPHANED;
            this.parent = null;
        }
    }

    public void unchanged() {
        if (this.garbageState != AbstractPart.GarbageState.UNVISITED && this.garbageState != AbstractPart.GarbageState.ORPHANED) {
            throw new IllegalStateException("Try to change state from " + this.garbageState.toString() + " to UNCHANGED. This is forbidden.");
        }
        this.garbageState = AbstractPart.GarbageState.UNCHANGED;
    }

    abstract boolean visit(IPartVisitor var1);

    public AbstractPart findPartAt(Point position, Class<?> expectedTileType) {
        if (expectedTileType == this.getClass()) {
            return this;
        }
        return null;
    }

    public abstract void createPartControl(Composite var1);

    @Override
    public abstract Control getControl();

    public abstract void reparent(TabFolderPart var1);

    public void fillPartMap(PartLists partMap) {
        partMap.addLeaf(this);
        this.garbageState = AbstractPart.GarbageState.UNVISITED;
    }

    @Override
    public Object getRawModel() {
        return this.rawModel;
    }

    @Override
    public String getPageTitle() {
        return null;
    }

    @Override
    public Image getPageIcon() {
        return null;
    }

    public void refreshTab() {
        this.getParent().refreshPageTab(this);
    }

    public abstract void setFocus();

    public abstract void dispose();

    public abstract void disposeThisAndChildren();

    public abstract void garbage();

    public boolean isPartFor(Object realModel) {
        return this.rawModel == realModel;
    }
}

