/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.extension.commands;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.extension.commands.IModelCreationCommand;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;

public abstract class ModelCreationCommandBase
implements IModelCreationCommand {
    public void createModel(final DiResourceSet diResourceSet) {
        TransactionalEditingDomain transactionalEditingDomain = diResourceSet.getTransactionalEditingDomain();
        RecordingCommand command = new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                ModelCreationCommandBase.this.runAsTransaction(diResourceSet);
            }
        };
        transactionalEditingDomain.getCommandStack().execute((Command)command);
    }

    protected void runAsTransaction(DiResourceSet diResourceSet) {
        final Resource modelResource = diResourceSet.getModelResource();
        TransactionalEditingDomain editingDomain = diResourceSet.getTransactionalEditingDomain();
        AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, "Initialize model", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                CommandResult commandResult = CommandResult.newErrorCommandResult((String)"Error during diagram creation");
                EObject model = ModelCreationCommandBase.this.getRootElement(modelResource);
                ModelCreationCommandBase.this.attachModelToResource(model, modelResource);
                ModelCreationCommandBase.this.initializeModel(model);
                return CommandResult.newOKCommandResult();
            }
        };
        editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)command));
    }

    protected void initializeModel(EObject owner) {
    }

    protected EObject getRootElement(Resource modelResource) {
        EObject rootElement = null;
        if (modelResource != null && modelResource.getContents() != null && modelResource.getContents().size() > 0) {
            Object root = modelResource.getContents().get(0);
            if (root instanceof EObject) {
                rootElement = (EObject)root;
            }
        } else {
            rootElement = this.createRootElement();
        }
        return rootElement;
    }

    protected void attachModelToResource(EObject root, Resource resource) {
        resource.getContents().add((Object)root);
    }

    protected abstract EObject createRootElement();
}

