/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.IModelSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelSnippetList;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;

public abstract class AbstractBaseModel
implements IModel {
    private ModelSet modelSet;
    protected ModelSnippetList snippets = new ModelSnippetList();
    protected Resource resource;
    protected URI resourceURI;

    public void init(ModelSet modelManager) {
        this.modelSet = modelManager;
    }

    protected ModelSet getModelManager() {
        return this.modelSet;
    }

    protected ResourceSet getResourceSet() {
        return this.modelSet;
    }

    public Resource getResource() {
        return this.resource;
    }

    public URI getResourceURI() {
        return this.resourceURI;
    }

    public abstract String getIdentifier();

    protected abstract String getModelFileExtension();

    protected boolean resourceIsSet() {
        return this.resource != null;
    }

    public void createModel(IPath fullPath) {
        this.resourceURI = this.getPlatformURI(fullPath.addFileExtension(this.getModelFileExtension()));
        this.resource = this.getModelManager().createResource(this.resourceURI);
    }

    protected URI getPlatformURI(IPath path) {
        return URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
    }

    public void loadModel(IFile file) {
        this.loadModel(file.getFullPath().removeFileExtension());
    }

    public void loadModel(IPath fullPathWithoutExtension) {
        WrappedException error = null;
        this.resourceURI = this.getPlatformURI(fullPathWithoutExtension.addFileExtension(this.getModelFileExtension()));
        try {
            this.resource = this.modelSet.getResource(this.resourceURI, true);
        }
        catch (WrappedException e) {
            if (ModelUtils.isDegradedModeAllowed(e.getCause())) {
                this.resource = this.modelSet.getResource(this.resourceURI, false);
            }
            error = e;
        }
        this.snippets.performStart(this);
        if (error != null) {
            throw error;
        }
    }

    public void importModel(IPath fullPathWithoutExtension) {
        this.loadModel(fullPathWithoutExtension);
    }

    public void saveModel() throws IOException {
        if (!this.getModelManager().getTransactionalEditingDomain().isReadOnly(this.resource) && !ModelUtils.resourceFailedOnLoad(this.resource)) {
            this.resource.save(null);
        }
    }

    public void changeModelPath(IPath fullPath) {
        this.resourceURI = this.getPlatformURI(fullPath.addFileExtension(this.getModelFileExtension()));
        this.resource.setURI(this.resourceURI);
    }

    public void unload() {
        this.snippets.performDispose(this);
        if (this.resource != null) {
            this.resource.unload();
            this.resource = null;
        }
    }

    public void addModelSnippet(IModelSnippet snippet) {
        this.snippets.add(snippet);
    }
}

