/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.uml;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelUtils;
import org.eclipse.papyrus.infra.core.resource.uml.UmlModel;

public class ExtendedUmlModel
extends UmlModel {
    public void loadModel(IFile file) {
        IPath fullPath = file.getFullPath().removeFileExtension();
        if (this.resource == null) {
            IContainer folder = file.getParent();
            try {
                IResource[] files;
                IResource[] iResourceArray = files = folder.members();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    String extension = r.getFullPath().getFileExtension();
                    if (r.getFullPath().removeFileExtension().lastSegment().equals(fullPath.lastSegment()) && !"di".equalsIgnoreCase(extension) && !"notation".equalsIgnoreCase(extension) && Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().get(extension) != null) {
                        this.resourceURI = this.getPlatformURI(r.getFullPath());
                        try {
                            this.resource = this.getResourceSet().getResource(this.resourceURI, true);
                            break;
                        }
                        catch (WrappedException e) {
                            if (ModelUtils.isDegradedModeAllowed(e.getCause())) {
                                this.resource = this.getResourceSet().getResource(this.resourceURI, false);
                                if (this.resource == null) {
                                    throw e;
                                }
                            }
                            break;
                        }
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }
}

