/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource.uml;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;

public class UmlModel
extends AbstractBaseModel
implements IModel {
    public static final String UML_FILE_EXTENSION = "uml";
    public static final String MODEL_ID = "org.eclipse.papyrus.infra.core.resource.uml.UmlModel";

    public void createModel(IPath fullPath) {
        this.resourceURI = this.getPlatformURI(fullPath.addFileExtension(UML_FILE_EXTENSION));
        this.resource = this.getResourceSet().createResource(this.resourceURI, this.getContentType());
    }

    protected String getContentType() {
        return "org.eclipse.uml2.uml";
    }

    protected String getModelFileExtension() {
        return UML_FILE_EXTENSION;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    public EObject lookupRoot() throws NotFoundException {
        try {
            return (EObject)this.resource.getContents().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NotFoundException("No root defined in the model");
        }
    }
}

