/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;

public class OpenDiagramCommand
extends AbstractTransactionalCommand {
    private EObject diagramToOpen = null;
    private ICommand previousCreateDiagramCommand = null;

    public OpenDiagramCommand(TransactionalEditingDomain editingDomain, EObject diagram) {
        super(editingDomain, "Open diagram", null);
        this.diagramToOpen = diagram;
    }

    public OpenDiagramCommand(TransactionalEditingDomain editingDomain, ICommand previousCreateDiagramCommand) {
        super(editingDomain, "Open diagram", null);
        this.previousCreateDiagramCommand = previousCreateDiagramCommand;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        try {
            Object possibleDiagramToOpen;
            if (this.diagramToOpen == null && this.previousCreateDiagramCommand != null && (possibleDiagramToOpen = this.previousCreateDiagramCommand.getCommandResult().getReturnValue()) instanceof EObject) {
                this.diagramToOpen = (EObject)possibleDiagramToOpen;
            }
            if (this.diagramToOpen != null) {
                if (!(this.getEditingDomain().getResourceSet() instanceof DiResourceSet)) {
                    throw new IllegalStateException("Enable to get the page manager");
                }
                DiResourceSet diResourceSet = (DiResourceSet)this.getEditingDomain().getResourceSet();
                IPageMngr pageMngr = EditorUtils.getIPageMngr(diResourceSet.getDiResource());
                if (pageMngr.isOpen((Object)this.diagramToOpen)) {
                    pageMngr.closePage((Object)this.diagramToOpen);
                }
                pageMngr.openPage((Object)this.diagramToOpen);
            }
            return CommandResult.newOKCommandResult();
        }
        catch (Exception e) {
            throw new ExecutionException("Can't open diagram", (Throwable)e);
        }
    }
}

