/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.providers;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.uicore.CustomizableModelLabelProvider;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.providers.StandardEMFLabelProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.providers.IDetailLabelProvider;
import org.eclipse.swt.graphics.Image;

public class EMFLabelProvider
extends CustomizableModelLabelProvider
implements IDetailLabelProvider {
    protected ILabelProvider baseEMFLabelProvider = new StandardEMFLabelProvider();

    public EMFLabelProvider() {
        super(Activator.getDefault().getCustomizationManager());
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof ITreeElement) {
            return super.getText(element);
        }
        EObject eObject = EMFHelper.getEObject(element);
        if (eObject != null) {
            return this.getText(eObject);
        }
        if (element instanceof IStructuredSelection) {
            return this.getText((IStructuredSelection)element);
        }
        return element.toString();
    }

    protected String getText(EObject element) {
        return this.baseEMFLabelProvider.getText((Object)element);
    }

    protected String getText(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return "";
        }
        Object element = selection.getFirstElement();
        return this.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ITreeElement) {
            return super.getImage(element);
        }
        EObject eObject = EMFHelper.getEObject(element);
        if (eObject != null) {
            return this.getImage(eObject);
        }
        if (element instanceof IStructuredSelection) {
            return this.getImage((IStructuredSelection)element);
        }
        return null;
    }

    protected Image getImage(EObject eObject) {
        return this.baseEMFLabelProvider.getImage((Object)eObject);
    }

    protected Image getImage(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        Object element = selection.getFirstElement();
        return this.getImage(element);
    }

    public String getDetail(Object object) {
        object = EMFHelper.getEObject(object);
        return String.valueOf(this.getText(object)) + " - " + this.getQualifiedClassName(object);
    }

    protected String getQualifiedClassName(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EClass eClass = eObject.eClass();
            return EMFHelper.getQualifiedName((EClassifier)eClass, "::");
        }
        return "";
    }
}

