/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFHelper {
    public static EClass getEClass(String nsUri, String className) {
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
        if (ePackage == null) {
            Activator.log.warn("Cannot find an EPackage matching the nsURI " + nsUri);
            return null;
        }
        return EMFHelper.getEClass(ePackage, className);
    }

    public static EClass getEClass(EPackage metamodel, String className) {
        EClassifier classifier = metamodel.getEClassifier(className);
        if (classifier == null) {
            Activator.log.warn("Classifier " + className + " not found in metamodel " + metamodel.getName() + " (" + metamodel.getNsURI() + ")");
        }
        if (classifier instanceof EClass) {
            return (EClass)classifier;
        }
        Activator.log.warn("Classifier " + className + " in " + metamodel.getName() + " (" + metamodel.getNsURI() + ") is not an EClass");
        return null;
    }

    public static boolean isInstance(EObject element, String className, EPackage metamodel) {
        EClassifier theClass = metamodel.getEClassifier(className);
        if (theClass == null) {
            Activator.log.warn("Class " + className + " not found in Metamodel : " + metamodel.getName() + " (" + metamodel.getNsURI() + ")");
            return false;
        }
        return theClass.isInstance((Object)element);
    }

    public static boolean isSubclass(EClass eClass, EClass fromClass) {
        if (eClass != null && fromClass == EcorePackage.eINSTANCE.getEObject()) {
            return true;
        }
        if (eClass == fromClass) {
            return true;
        }
        EList superTypes = eClass.getEAllSuperTypes();
        return superTypes.contains(fromClass);
    }

    public static EObject getEObject(Object source) {
        if (source instanceof EObject) {
            return (EObject)source;
        }
        if (source instanceof IAdaptable) {
            EObject eObject = (EObject)((IAdaptable)source).getAdapter(EObject.class);
            if (eObject == null) {
                eObject = (EObject)((IAdaptable)source).getAdapter(EReference.class);
            }
            return eObject;
        }
        return null;
    }

    public static EditingDomain resolveEditingDomain(Object source) {
        return EMFHelper.resolveEditingDomain(EMFHelper.getEObject(source));
    }

    public static EditingDomain resolveEditingDomain(EObject source) {
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)source);
        if (domain == null) {
            try {
                domain = ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return domain;
    }

    public static String getQualifiedName(EClassifier eClassifier, String separator) {
        return String.valueOf(EMFHelper.getQualifiedName(eClassifier.getEPackage(), separator)) + separator + eClassifier.getName();
    }

    public static String getQualifiedName(EPackage ePackage, String separator) {
        if (ePackage.getESuperPackage() == null) {
            return ePackage.getName();
        }
        return String.valueOf(EMFHelper.getQualifiedName(ePackage.getESuperPackage(), separator)) + separator + ePackage.getName();
    }

    public static EObject loadEMFModel(ResourceSet resourceSet, URI uri) throws IOException {
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
        }
        try {
            Resource resource = resourceSet.getResource(uri, true);
            if (resource != null && !resource.getContents().isEmpty()) {
                return (EObject)resource.getContents().get(0);
            }
        }
        catch (Exception ex) {
            IOException exception = new IOException(ex.toString());
            exception.initCause(ex);
            throw exception;
        }
        return null;
    }

    public static EPackage getRootPackage(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        if (ePackage.getESuperPackage() == null) {
            return ePackage;
        }
        return EMFHelper.getRootPackage(ePackage.getESuperPackage());
    }

    public static List<EClass> getSubclassesOf(EClass type, boolean concreteClassesOnly) {
        LinkedList<EClass> result = new LinkedList<EClass>();
        if (!concreteClassesOnly || !type.isAbstract() && !type.isInterface()) {
            result.add(type);
        }
        EPackage ePackage = EMFHelper.getRootPackage(type.getEPackage());
        EMFHelper.getSubclassesOf(type, ePackage, result, concreteClassesOnly);
        return result;
    }

    private static void getSubclassesOf(EClass type, EPackage fromPackage, List<EClass> result, boolean concreteClassesOnly) {
        for (EClassifier classifier : fromPackage.getEClassifiers()) {
            EClass eClass;
            if (!(classifier instanceof EClass) || !(eClass = (EClass)classifier).getEAllSuperTypes().contains((Object)type) || concreteClassesOnly && (eClass.isAbstract() || eClass.isInterface())) continue;
            result.add(eClass);
        }
        for (EPackage subPackage : fromPackage.getESubpackages()) {
            EMFHelper.getSubclassesOf(type, subPackage, result, concreteClassesOnly);
        }
    }

    public static boolean isReadOnly(EObject eObject) {
        EditingDomain domain = EMFHelper.resolveEditingDomain(eObject);
        return EMFHelper.isReadOnly(eObject, domain);
    }

    public static boolean isReadOnly(EObject eObject, EditingDomain domain) {
        return EMFHelper.isReadOnly(eObject.eResource(), domain);
    }

    public static boolean isReadOnly(Resource resource, EditingDomain domain) {
        if (domain instanceof AdapterFactoryEditingDomain) {
            return ((AdapterFactoryEditingDomain)domain).isReadOnly(resource);
        }
        if (resource == null) {
            return false;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return false;
        }
        Map attributes = resourceSet.getURIConverter().getAttributes(resource.getURI(), null);
        Boolean readOnly = (Boolean)attributes.get("readOnly");
        return readOnly == null ? false : readOnly;
    }

    public static boolean isRequired(EStructuralFeature feature) {
        if (feature.getEType() instanceof EEnum) {
            return true;
        }
        if (feature.getLowerBound() >= 1) {
            return true;
        }
        if (feature.getEType().getInstanceClass().isPrimitive() && !feature.isUnsettable()) {
            return true;
        }
        return feature.getDefaultValueLiteral() != null;
    }

    public static Set<EPackage> getMetamodels(Resource resource) {
        HashSet<EPackage> metamodels = new HashSet<EPackage>();
        if (resource != null) {
            ArrayList contents = new ArrayList(resource.getContents());
            for (EObject current : contents) {
                metamodels.add(current.eClass().getEPackage());
            }
        }
        return metamodels;
    }

    public static final String getXMIID(EObject object) {
        String objectID = null;
        if (object != null && object.eResource() instanceof XMIResource) {
            objectID = ((XMIResource)object.eResource()).getID(object);
        }
        return objectID;
    }
}

