/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.AbstractServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceRegistryAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceUtilsForResource
extends AbstractServiceUtils<Resource> {
    private static final ServiceUtilsForResource instance = new ServiceUtilsForResource();

    public static final ServiceUtilsForResource getInstance() {
        return instance;
    }

    public ServicesRegistry getServiceRegistry(Resource from) throws ServiceException {
        if (from == null || from.getResourceSet() == null) {
            throw new ServiceNotFoundException("Can't find the ResourceSet needed retrieve the ServiceRegistry.");
        }
        ServiceRegistryAdapterFactory factory = (ServiceRegistryAdapterFactory)EcoreUtil.getAdapterFactory((List)from.getResourceSet().getAdapterFactories(), (Object)ServiceRegistryAdapterFactory.TYPE_ID);
        if (factory == null) {
            throw new ServiceNotFoundException("Can't find the ServiceRegistry. No Adapter is attached to the ResourceSet. Check if the proper service is ");
        }
        return factory.getServicesRegistry();
    }
}

