/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.utils;

import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceRegistryAdapterFactory;

public class ServiceUtilsForResourceInitializerService
implements IService {
    ServicesRegistry servicesRegistry;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
        ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)servicesRegistry);
        if (this.lookupServiceRegistryAdapterFactory((ResourceSet)modelSet) != null) {
            return;
        }
        ServiceRegistryAdapterFactory factory = new ServiceRegistryAdapterFactory(servicesRegistry);
        modelSet.getAdapterFactories().add((Object)factory);
    }

    private ServiceRegistryAdapterFactory lookupServiceRegistryAdapterFactory(ResourceSet resourceSet) {
        ServiceRegistryAdapterFactory factory = (ServiceRegistryAdapterFactory)EcoreUtil.getAdapterFactory((List)resourceSet.getAdapterFactories(), (Object)ServiceRegistryAdapterFactory.TYPE_ID);
        return factory;
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)this.servicesRegistry);
            ServiceRegistryAdapterFactory factory = this.lookupServiceRegistryAdapterFactory((ResourceSet)modelSet);
            modelSet.getAdapterFactories().remove((Object)factory);
        }
        catch (BadStateException badStateException) {
            // empty catch block
        }
    }
}

