/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.extendedtypes;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IContainerDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationTypeDescriptor;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.papyrus.infra.extendedtypes.Activator;
import org.eclipse.papyrus.infra.extendedtypes.ExtendedEditHelperAdvice;
import org.eclipse.papyrus.infra.extendedtypes.ExtendedElementTypeConfiguration;
import org.eclipse.papyrus.infra.extendedtypes.IconEntry;
import org.osgi.framework.Bundle;

public class ExtendedSemanticTypeDescriptor
implements ISpecializationTypeDescriptor {
    public static final String EXTENDED_ELEMENTS = "ExtendedElements";
    private final ExtendedElementTypeConfiguration configuration;
    private List<IElementType> specializedTypes = null;

    public ExtendedSemanticTypeDescriptor(ExtendedElementTypeConfiguration configuration) {
        this.configuration = configuration;
    }

    public ExtendedElementTypeConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getId() {
        return this.configuration.getId();
    }

    public URL getIconURL() {
        IconEntry entry = this.configuration.getIconEntry();
        Bundle bundle = Platform.getBundle((String)entry.getBundleId());
        if (bundle == null) {
            return null;
        }
        URL result = bundle.getEntry(entry.getIconPath());
        return result;
    }

    public String getName() {
        return this.configuration.getName();
    }

    public String getKindName() {
        return this.configuration.getKindName();
    }

    public String getParamValue(String paramName) {
        if ("semanticHint".equals(paramName)) {
            return this.configuration.getHint();
        }
        return EXTENDED_ELEMENTS;
    }

    public IContainerDescriptor getContainerDescriptor() {
        return null;
    }

    public IElementType[] getSpecializedTypes() {
        if (this.specializedTypes == null) {
            this.specializedTypes = new ArrayList<IElementType>();
            for (String specializedTypeId : this.configuration.getSpecializedTypesID()) {
                IElementType type = ElementTypeRegistry.getInstance().getType(specializedTypeId);
                if (type != null) {
                    this.specializedTypes.add(type);
                    continue;
                }
                Activator.log.error("Impossible to find the type " + specializedTypeId, null);
            }
        }
        return this.specializedTypes.toArray(new IElementType[this.specializedTypes.size()]);
    }

    public IElementMatcher getMatcher() {
        return null;
    }

    public IEditHelperAdvice getEditHelperAdvice() {
        return new ExtendedEditHelperAdvice();
    }
}

