/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common;

import java.beans.PropertyChangeSupport;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.MEditingDomainElement;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

public class ModelManagerEditor {
    public static final String DIAGRAM_ADDED = "DIAGRAM_ADDED";
    public static final String DIAGRAM_MOVED = "DIAGRAM_MOVED";
    public static final String DIAGRAM_REMOVED = "DIAGRAM_REMOVED";
    protected IDocumentProvider documentProvider;
    protected IEditorInput editorInput;
    protected IEditorSite site;
    private PropertyChangeSupport diagramListListener = new PropertyChangeSupport(this);
    private Adapter adapter = new Adapter(){
        Notifier notifier;

        public Notifier getTarget() {
            return this.notifier;
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }

        public void notifyChanged(Notification notification) {
            int eventType = notification.getEventType();
            if (eventType == 3) {
                Object newValue = notification.getNewValue();
                if (newValue instanceof Diagram) {
                    ModelManagerEditor.this.diagramListListener.firePropertyChange(ModelManagerEditor.DIAGRAM_ADDED, null, newValue);
                }
            } else if (eventType == 7) {
                Object newValue = notification.getNewValue();
                if (newValue instanceof Diagram) {
                    ModelManagerEditor.this.diagramListListener.firePropertyChange(ModelManagerEditor.DIAGRAM_MOVED, null, newValue);
                }
            } else if (eventType == 4) {
                Object newValue = notification.getNewValue();
                if (newValue == null) {
                    Activator.log.debug(String.valueOf(this.getClass().getName()) + "- Warning: can't get removed object.");
                }
                if (newValue instanceof Diagram) {
                    ModelManagerEditor.this.diagramListListener.firePropertyChange(ModelManagerEditor.DIAGRAM_REMOVED, null, newValue);
                }
            }
        }

        public void setTarget(Notifier newTarget) {
            this.notifier = newTarget;
        }
    };
    private int fErrorCorrectionOnSave;

    public ModelManagerEditor(IDocumentProvider documentProvider) {
        this.documentProvider = documentProvider;
    }

    public IDocumentProvider getDocumentProvider() {
        return this.documentProvider;
    }

    public TransactionalEditingDomain getEditingDomain() {
        IDocument document;
        IDocument iDocument = document = this.getEditorInput() != null ? this.getDocumentProvider().getDocument((Object)this.getEditorInput()) : null;
        if (document instanceof IDiagramDocument) {
            return ((IDiagramDocument)document).getEditingDomain();
        }
        return this.getEditorInput() instanceof MEditingDomainElement ? ((MEditingDomainElement)this.getEditorInput()).getEditingDomain() : null;
    }

    public void setInput(IEditorInput input) {
        Activator.log.debug(this + ".setInput(IEditorInput input)");
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.editorInput = input;
        this.site = site;
        try {
            this.getDocumentProvider().connect((Object)input);
        }
        catch (CoreException x) {
            String title = EditorMessages.Editor_error_setinput_title;
            String msg = EditorMessages.Editor_error_setinput_message;
            Shell shell = site.getShell();
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    public PropertyChangeSupport getDiagramListListener() {
        return this.diagramListListener;
    }

    public void activate() {
        this.getNotationModelEResource().eAdapters().add((Object)this.adapter);
    }

    public void deactivate() {
        this.getNotationModelEResource().eAdapters().remove((Object)this.adapter);
    }

    private Resource getNotationModelEResource() {
        DiagramDocument document = (DiagramDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        Diagram diagram = document.getDiagram();
        return diagram.eResource();
    }

    public Resource getNotationResource() {
        return this.getNotationModelEResource();
    }

    public Resource getDomainResource() {
        DiagramDocument document = (DiagramDocument)this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        Diagram diagram = document.getDiagram();
        EObject rootObject = diagram.getElement();
        return rootObject.eResource();
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                String title = EditorMessages.Editor_error_save_deleted_title;
                String msg = EditorMessages.Editor_error_save_deleted_message;
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
        } else {
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            this.performSave(false, progressMonitor);
        }
    }

    protected void updateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        try {
            provider.updateStateCache((Object)input);
        }
        catch (CoreException x) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
            ILog log = Platform.getLog((Bundle)bundle);
            log.log(x.getStatus());
        }
    }

    protected void validateState(IEditorInput input) {
        IDocumentProvider provider = this.getDocumentProvider();
        try {
            provider.validateState((Object)input, (Object)this.getSite().getShell());
        }
        catch (CoreException x) {
            IStatus status = x.getStatus();
            if (status == null || status.getSeverity() != 8) {
                Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
                ILog log = Platform.getLog((Bundle)bundle);
                log.log(x.getStatus());
                Shell shell = this.getSite().getShell();
                String title = EditorMessages.Editor_error_validateEdit_title;
                String msg = EditorMessages.Editor_error_validateEdit_message;
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
            }
            return;
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider provider = this.getDocumentProvider();
        if (provider == null) {
            return;
        }
        try {
            try {
                provider.aboutToChange((Object)this.getEditorInput());
                IEditorInput input = this.getEditorInput();
                provider.saveDocument(progressMonitor, (Object)input, this.getDocumentProvider().getDocument((Object)input), overwrite);
            }
            catch (CoreException x) {
                IStatus status = x.getStatus();
                if (status == null || status.getSeverity() != 8) {
                    this.handleExceptionOnSave(x, progressMonitor);
                }
                provider.changed((Object)this.getEditorInput());
            }
        }
        finally {
            provider.changed((Object)this.getEditorInput());
        }
    }

    protected void performSaveAs(IProgressMonitor progressMonitor) {
        boolean success;
        block19: {
            IFile original;
            Shell shell = this.getSite().getShell();
            IEditorInput input = this.getEditorInput();
            SaveAsDialog dialog = new SaveAsDialog(shell);
            IFile iFile = original = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile() : null;
            if (original != null) {
                dialog.setOriginalFile(original);
            }
            dialog.create();
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider == null) {
                return;
            }
            if (provider.isDeleted((Object)input) && original != null) {
                String message = NLS.bind((String)Messages.ModelManagerEditor_SavingDeletedFile, (Object)original.getName());
                dialog.setErrorMessage(null);
                dialog.setMessage(message, 2);
            }
            if (dialog.open() == 1) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IPath filePath = dialog.getResult();
            if (filePath == null) {
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
                return;
            }
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(filePath);
            FileEditorInput newInput = new FileEditorInput(file);
            IEditorMatchingStrategy matchingStrategy = this.getEditorDescriptor().getEditorMatchingStrategy();
            IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
            int i = 0;
            while (i < editorRefs.length) {
                if (matchingStrategy.matches(editorRefs[i], (IEditorInput)newInput)) {
                    MessageDialog.openWarning((Shell)shell, (String)Messages.ModelManagerEditor_SaveAsErrorTitle, (String)Messages.ModelManagerEditor_SaveAsErrorMessage);
                    return;
                }
                ++i;
            }
            success = false;
            try {
                try {
                    provider.aboutToChange((Object)newInput);
                    this.getDocumentProvider().saveDocument(progressMonitor, (Object)newInput, this.getDocumentProvider().getDocument((Object)this.getEditorInput()), true);
                    success = true;
                }
                catch (CoreException x) {
                    IStatus status = x.getStatus();
                    if (status == null || status.getSeverity() != 8) {
                        ErrorDialog.openError((Shell)shell, (String)Messages.ModelManagerEditor_SaveErrorTitle, (String)Messages.ModelManagerEditor_SaveErrorMessage, (IStatus)x.getStatus());
                    }
                    provider.changed((Object)newInput);
                    if (success) {
                        this.setInput((IEditorInput)newInput);
                    }
                    break block19;
                }
            }
            catch (Throwable throwable) {
                provider.changed((Object)newInput);
                if (success) {
                    this.setInput((IEditorInput)newInput);
                }
                throw throwable;
            }
            provider.changed((Object)newInput);
            if (success) {
                this.setInput((IEditorInput)newInput);
            }
        }
        if (progressMonitor != null) {
            progressMonitor.setCanceled(!success);
        }
    }

    protected final IEditorDescriptor getEditorDescriptor() {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor editorDesc = editorRegistry.findEditor(this.getSite().getId());
        return editorDesc;
    }

    protected void handleExceptionOnSave(CoreException exception, IProgressMonitor progressMonitor) {
        try {
            ++this.fErrorCorrectionOnSave;
            Shell shell = this.getSite().getShell();
            boolean isSynchronized = false;
            IDocumentProvider p = this.getDocumentProvider();
            isSynchronized = p.isSynchronized((Object)this.getEditorInput());
            if (this.isNotSynchronizedException(exception) && this.fErrorCorrectionOnSave == 1 && !isSynchronized) {
                String title = EditorMessages.Editor_error_save_outofsync_title;
                String msg = EditorMessages.Editor_error_save_outofsync_message;
                if (MessageDialog.openQuestion((Shell)shell, (String)title, (String)msg)) {
                    this.performSave(true, progressMonitor);
                } else if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
            } else {
                String title = EditorMessages.Editor_error_save_title;
                String msg = EditorMessages.Editor_error_save_message;
                ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)exception.getStatus());
                if (progressMonitor != null) {
                    progressMonitor.setCanceled(true);
                }
            }
        }
        finally {
            --this.fErrorCorrectionOnSave;
        }
    }

    private boolean isNotSynchronizedException(CoreException ex) {
        if (ex == null) {
            return false;
        }
        IStatus status = ex.getStatus();
        if (status == null || status instanceof MultiStatus) {
            return false;
        }
        if (status.getException() != null) {
            return false;
        }
        return status.getCode() == 274;
    }

    public IEditorSite getSite() {
        return this.site;
    }
}

