/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.widgets.editors;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class FontEditor
extends AbstractValueEditor {
    private CCombo fontCombo;

    public FontEditor(Composite parent, int style) {
        super(parent, style);
        this.fontCombo = factory.createCCombo((Composite)this, style | 8 | 0x800);
        this.fontCombo.setLayoutData((Object)this.getDefaultLayoutData());
        FontData[] fontDatas = this.getDisplay().getFontList(null, true);
        Arrays.sort(fontDatas, new Comparator<FontData>(){

            @Override
            public int compare(FontData font1, FontData font2) {
                return Collator.getInstance().compare(font1.getName(), font2.getName());
            }
        });
        HashSet<String> fonts = new HashSet<String>();
        FontData[] fontDataArray = fontDatas;
        int n = fontDatas.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            if (data.getName() != null && fonts.add(data.getName())) {
                this.fontCombo.add(data.getName());
            }
            ++n2;
        }
        this.setWidgetObservable((IObservableValue)WidgetProperties.selection().observe((Widget)this.fontCombo));
    }

    public String getValue() {
        int index = this.fontCombo.getSelectionIndex();
        return this.fontCombo.getItem(index);
    }

    public Object getEditableType() {
        return String.class;
    }

    public void setReadOnly(boolean readOnly) {
        this.fontCombo.setEnabled(!readOnly);
    }

    public boolean isReadOnly() {
        return !this.fontCombo.isEnabled();
    }

    public void setToolTipText(String text) {
        this.setLabelToolTipText(text);
        this.fontCombo.setToolTipText(text);
    }
}

