/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.decoration.IDecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.decoration.util.DecorationUtils;
import org.eclipse.papyrus.infra.services.decoration.util.IDecoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationService
extends Observable
implements IDecorationService {
    private ServicesRegistry servicesRegistry;
    private final Map<String, Decoration> decorations = new HashMap<String, Decoration>();

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
    }

    @Override
    public void startService() throws ServiceException {
    }

    @Override
    public void disposeService() throws ServiceException {
    }

    @Override
    public void notifyListeners(DecorationService decorationService) {
        this.setChanged();
        this.notifyObservers(decorationService);
    }

    public ServicesRegistry getServicesRegistry() {
        return this.servicesRegistry;
    }

    public void setServicesRegistry(ServicesRegistry servicesRegistry) {
        this.servicesRegistry = servicesRegistry;
    }

    public Map<String, Decoration> getDecorations() {
        return this.decorations;
    }

    @Override
    public synchronized void addListener(Observer o) {
        this.addObserver(o);
    }

    @Override
    public synchronized void deleteListener(Observer o) {
        this.deleteObserver(o);
    }

    @Override
    public void removeDecoration(String id) {
        if (this.decorations.get(id) != null) {
            this.decorations.remove(id);
        }
        this.notifyListeners(this);
    }

    @Override
    public void addDecoration(String id, EObject element, int severity, String message) {
        if (this.decorations.get(id) == null) {
            this.decorations.put(id, new Decoration(id, severity, message, element));
        }
        this.notifyListeners(this);
    }

    @Override
    public void addDecoration(String id, EObject element, ImageDescriptor decoration, String message) {
        if (this.decorations.get(id) == null) {
            this.decorations.put(id, new Decoration(id, decoration, message, element));
        }
        this.notifyListeners(this);
    }

    @Override
    public IDecoration getDecoration(Object element, boolean navigateToParents) {
        DecorationUtils tool = new DecorationUtils(element);
        tool.tryChildIfEmpty();
        return tool.getDecoration(this, navigateToParents);
    }
}

