/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration.util;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.WordUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.services.decoration.Activator;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationUtils {
    private Object element;
    private EObject eObject;

    public DecorationUtils(Object element) {
        if (element == null) {
            throw new IllegalArgumentException("The decorated element shall not be null");
        }
        EObject eObject = (EObject)Platform.getAdapterManager().getAdapter(element, EObject.class);
        if (eObject == null) {
            throw new IllegalArgumentException("The decorated element cannot be resolved to an EObject");
        }
        this.element = element;
        this.setEObject(eObject);
    }

    public DecorationUtils(EObject eObject) {
        if (eObject == null) {
            throw new IllegalArgumentException("The decorated EObject shall not be null");
        }
        this.setEObject(eObject);
    }

    public void tryChildIfEmpty() {
        List items;
        if (this.getEObject() == null && this.element instanceof LinkItem && (items = ((LinkItem)this.element).getChildrenElements()).size() > 0 && items.get(0) instanceof EObject) {
            this.setEObject((EObject)items.get(0));
        }
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public void setEObject(EObject eObject) {
        this.eObject = eObject;
    }

    public Map<String, Decoration> getDecorations(DecorationService decorationService) {
        return decorationService.getDecorations();
    }

    public MarkChildren getHierarchicalMarkers() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String choice = store.getString(Activator.getDefault().HIERARCHICAL_MARKERS);
        if (choice.equals("NO")) {
            return MarkChildren.NO;
        }
        if (choice.equals("DIRECT")) {
            return MarkChildren.DIRECT;
        }
        return MarkChildren.ALL;
    }

    public int getDecorationSeverity(DecorationService decorationService, boolean navigateToParents) {
        Map<String, Decoration> decorations = this.getDecorations(decorationService);
        MarkChildren markChildren = this.getHierarchicalMarkers();
        int severity = 0;
        if (decorations != null) {
            block0: for (Map.Entry<String, Decoration> pairs : decorations.entrySet()) {
                Decoration decoration = pairs.getValue();
                EObject eObjectOfDecorator = decoration.getElement();
                boolean first = true;
                while (eObjectOfDecorator != null) {
                    int severityI;
                    if (eObjectOfDecorator == this.getEObject() && (severityI = decoration.getSeverity()) > severity) {
                        severity = severityI;
                    }
                    if (!navigateToParents) continue block0;
                    eObjectOfDecorator = eObjectOfDecorator.eContainer();
                    if (markChildren != MarkChildren.ALL && (!first || markChildren == MarkChildren.NO)) continue block0;
                    first = false;
                }
            }
        }
        return severity;
    }

    public String getDecorationMessage(DecorationService decorationService) {
        Map<String, Decoration> decorations = this.getDecorations(decorationService);
        if (decorations != null) {
            String message = "";
            for (Map.Entry<String, Decoration> pairs : decorations.entrySet()) {
                Decoration decoration = pairs.getValue();
                EObject eObjectOfDecorator = decoration.getElement();
                if (eObjectOfDecorator != this.getEObject()) continue;
                if (message.length() > 0) {
                    message = String.valueOf(message) + "\n";
                }
                message = String.valueOf(message) + "- " + WordUtils.wrap((String)decoration.getMessage(), (int)100, (String)"\n  ", (boolean)true);
            }
            return message.length() > 0 ? message : null;
        }
        return null;
    }

    public Decoration getDecoration(DecorationService decorationService, boolean navigateToParents) {
        return new Decoration(this.getEObject().toString(), this.getDecorationSeverity(decorationService, navigateToParents), this.getDecorationMessage(decorationService), this.getEObject());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MarkChildren {
        NO,
        DIRECT,
        ALL;

    }
}

