/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.resourceloading;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ModelsReader;
import org.eclipse.papyrus.infra.core.resource.notation.NotationUtils;
import org.eclipse.papyrus.infra.core.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.infra.core.resource.uml.UmlUtils;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.services.resourceloading.IProxyManager;
import org.eclipse.papyrus.infra.services.resourceloading.impl.ProxyManager;

public class OnDemandLoadingModelSet
extends DiResourceSet {
    private Set<URI> uriLoading = new HashSet<URI>();
    private IProxyManager proxyManager;

    public OnDemandLoadingModelSet() {
        ModelsReader reader = new ModelsReader();
        reader.readModel((ModelSet)this);
        this.proxyManager = new ProxyManager((ModelSet)this);
    }

    public void unload() {
        super.unload();
        this.proxyManager.dispose();
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        URI resourceURI = uri.trimFragment();
        if (resourceURI.equals((Object)UmlUtils.getUmlModel((ModelSet)this).getResourceURI()) || resourceURI.equals((Object)NotationUtils.getNotationModel((ModelSet)this).getResourceURI()) || resourceURI.equals((Object)SashModelUtils.getSashModel((ModelSet)this).getResourceURI()) || this.uriLoading.contains(resourceURI)) {
            return super.getEObject(uri, loadOnDemand);
        }
        if (loadOnDemand) {
            return this.proxyManager.getEObjectFromStrategy(uri);
        }
        return null;
    }

    public void forceUriLoading(URI alwaysLoadedUri) {
        this.uriLoading.add(alwaysLoadedUri);
    }
}

