/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.widgets.providers.IFilteredLabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensibleLabelProvider
implements ILabelProvider,
ILabelProviderListener {
    private final Set<ILabelProviderListener> listeners = new LinkedHashSet<ILabelProviderListener>();
    private final SortedMap<Integer, List<IFilteredLabelProvider>> providers = new TreeMap<Integer, List<IFilteredLabelProvider>>();
    private final ILabelProvider defaultProvider = new LabelProvider();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                provider.dispose();
            }
        }
        this.providers.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void registerProvider(int priority, IFilteredLabelProvider provider) {
        this.getProviders(priority).add(provider);
        provider.addListener(this);
    }

    public Image getImage(Object element) {
        return this.getProvider(element).getImage(element);
    }

    public String getText(Object element) {
        return this.getProvider(element).getText(element);
    }

    protected final ILabelProvider getProvider(Object element) {
        for (List<IFilteredLabelProvider> filteredProviders : this.providers.values()) {
            for (IFilteredLabelProvider provider : filteredProviders) {
                if (!provider.accept(element)) continue;
                return provider;
            }
        }
        return this.defaultProvider;
    }

    protected final List<IFilteredLabelProvider> getProviders(int priority) {
        if (!this.providers.containsKey(priority)) {
            this.providers.put(priority, new LinkedList());
        }
        return (List)this.providers.get(priority);
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }
}

