/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.internalblock.factory;

import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.gef.Tool;
import org.eclipse.gmf.runtime.diagram.ui.services.palette.PaletteFactory;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.papyrus.sysml.diagram.internalblock.provider.ElementTypes;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeConnectionTool;
import org.eclipse.papyrus.uml.diagram.common.service.AspectUnspecifiedTypeCreationTool;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;

public class DiagramPaletteFactory
extends PaletteFactory.Adapter {
    private static HashMap<String, IElementType[]> nodesToolIdTypesMap = new HashMap<String, IElementType[]>(){
        {
            this.put("internalblock.tool.block", new IElementType[]{SysMLElementTypes.BLOCK});
            this.put("internalblock.tool.blockpropertycomposite", new IElementType[]{SysMLElementTypes.PART_PROPERTY, SysMLElementTypes.REFERENCE_PROPERTY, SysMLElementTypes.ACTOR_PART_PROPERTY, SysMLElementTypes.VALUE_PROPERTY, UMLElementTypes.PROPERTY});
            this.put("internalblock.tool.flowport", new IElementType[]{SysMLElementTypes.FLOW_PORT});
            this.put("internalblock.tool.port", new IElementType[]{UMLElementTypes.PORT});
            this.put("internalblock.tool.part", new IElementType[]{SysMLElementTypes.PART_PROPERTY});
            this.put("internalblock.tool.reference", new IElementType[]{SysMLElementTypes.REFERENCE_PROPERTY});
            this.put("internalblock.tool.actorpart", new IElementType[]{SysMLElementTypes.ACTOR_PART_PROPERTY});
            this.put("internalblock.tool.value", new IElementType[]{SysMLElementTypes.VALUE_PROPERTY});
            this.put("internalblock.tool.property", new IElementType[]{UMLElementTypes.PROPERTY});
            this.put("internalblock.tool.flowport_na", new IElementType[]{SysMLElementTypes.FLOW_PORT_NA});
            this.put("internalblock.tool.flowport_in", new IElementType[]{SysMLElementTypes.FLOW_PORT_IN});
            this.put("internalblock.tool.flowport_out", new IElementType[]{SysMLElementTypes.FLOW_PORT_OUT});
            this.put("internalblock.tool.flowport_inout", new IElementType[]{SysMLElementTypes.FLOW_PORT_IN_OUT});
            this.put("internalblock.tool.constraint", new IElementType[]{UMLElementTypes.CONSTRAINT});
            this.put("internalblock.tool.comment", new IElementType[]{UMLElementTypes.COMMENT});
        }
    };
    private static HashMap<String, IElementType[]> edgesToolIdTypesMap = new HashMap<String, IElementType[]>(){
        {
            this.put("internalblock.tool.connector", new IElementType[]{UMLElementTypes.CONNECTOR});
            this.put("internalblock.tool.dependency", new IElementType[]{UMLElementTypes.DEPENDENCY});
            this.put("internalblock.tool.comment_constraint_link", new IElementType[]{ElementTypes.COMMENT_ANNOTATED_ELEMENT, ElementTypes.CONSTRAINT_CONSTRAINED_ELEMENT});
        }
    };

    public Tool createTool(String toolId) {
        IElementType[] types = nodesToolIdTypesMap.get(toolId);
        if (types != null) {
            return new AspectUnspecifiedTypeCreationTool(Arrays.asList(types));
        }
        types = edgesToolIdTypesMap.get(toolId);
        if (types != null) {
            return new AspectUnspecifiedTypeConnectionTool(Arrays.asList(types));
        }
        return null;
    }
}

