/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.GradientPreferenceConverter;
import org.eclipse.papyrus.infra.gmfdiag.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.uml.diagram.activity.draw2d.FlowLayoutAdvanced;
import org.eclipse.papyrus.uml.diagram.activity.draw2d.FlowLayoutAdvancedConstraint;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityPartitionActivityPartitionContentCompartmentEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.ActivityPartitionNameEditPart;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.ActivityPartitionItemSemanticEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.edit.policies.OpenDiagramEditPolicy;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LinesBorder;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.CenteredWrappedLabel;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.helper.PreferenceInitializerForElementHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypeFigureHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityPartitionEditPart
extends ShapeNodeEditPart
implements IPapyrusEditPart {
    public static final int VISUAL_ID = 3067;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    protected IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();

    public ActivityPartitionEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ActivityPartitionItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenDiagramEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new ActivityPartitionDescriptor();
        return this.primaryShape;
    }

    public ActivityPartitionDescriptor getPrimaryShape() {
        return (ActivityPartitionDescriptor)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityPartitionNameEditPart) {
            ((ActivityPartitionNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getPartitionLabel());
            return true;
        }
        if (childEditPart instanceof ActivityPartitionActivityPartitionContentCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getActivityPartitionCompartment();
            this.setupContentPane((IFigure)pane);
            pane.add(((ActivityPartitionActivityPartitionContentCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ActivityPartitionNameEditPart) {
            return true;
        }
        if (childEditPart instanceof ActivityPartitionActivityPartitionContentCompartmentEditPart) {
            RectangleFigure pane = this.getPrimaryShape().getActivityPartitionCompartment();
            this.setupContentPane((IFigure)pane);
            pane.remove(((ActivityPartitionActivityPartitionContentCompartmentEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof ActivityPartitionActivityPartitionContentCompartmentEditPart) {
            return this.getPrimaryShape().getActivityPartitionCompartment();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        String prefElementId = "ActivityPartition";
        IPreferenceStore store = UMLDiagramEditorPlugin.getInstance().getPreferenceStore();
        String preferenceConstantWitdh = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)17);
        String preferenceConstantHeight = PreferenceInitializerForElementHelper.getpreferenceKey((View)this.getNotationView(), (String)prefElementId, (int)16);
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(store.getInt(preferenceConstantWitdh), store.getInt(preferenceConstantHeight));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineWidth(width);
        }
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof Shape) {
            ((Shape)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5118));
    }

    public List<IElementType> getMARelTypesOnTarget() {
        ArrayList<IElementType> types = new ArrayList<IElementType>(1);
        types.add(UMLElementTypes.CommentAnnotatedElement_4006);
        return types;
    }

    public List<IElementType> getMATypesForSource(IElementType relationshipType) {
        LinkedList<IElementType> types = new LinkedList<IElementType>();
        if (relationshipType == UMLElementTypes.CommentAnnotatedElement_4006) {
            types.add(UMLElementTypes.Comment_3080);
        }
        return types;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        IPreferenceStore preferenceStore = (IPreferenceStore)this.getDiagramPreferencesHint().getPreferenceStore();
        Object result = null;
        if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor() || feature == NotationPackage.eINSTANCE.getFontStyle_FontColor() || feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
            String prefColor = null;
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"ActivityPartition", (int)3);
            } else if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"ActivityPartition", (int)2);
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                prefColor = PreferenceConstantHelper.getElementConstant((String)"ActivityPartition", (int)0);
            }
            result = FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)prefColor));
        } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency() || feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
            String prefGradient = PreferenceConstantHelper.getElementConstant((String)"ActivityPartition", (int)4);
            GradientPreferenceConverter gradientPreferenceConverter = new GradientPreferenceConverter(preferenceStore.getString(prefGradient));
            if (feature == NotationPackage.eINSTANCE.getFillStyle_Transparency()) {
                result = new Integer(gradientPreferenceConverter.getTransparency());
            } else if (feature == NotationPackage.eINSTANCE.getFillStyle_Gradient()) {
                result = gradientPreferenceConverter.getGradientData();
            }
        }
        if (result == null) {
            result = this.getStructuralFeatureValue(feature);
        }
        return result;
    }

    public class ActivityPartitionDescriptor
    extends RectangleFigure
    implements IPapyrusNodeUMLElementFigure {
        private RectangleFigure fActivityPartitionCompartment;
        private CenteredWrappedLabel fPartitionLabel;
        private RectangleFigure fFigureCompartmentLabelActivityPartition;
        private StereotypeFigureHelper stereotypeHelper;

        public ActivityPartitionDescriptor() {
            FlowLayoutAdvanced layoutThis = new FlowLayoutAdvanced();
            layoutThis.setStretchMinorAxis(true);
            layoutThis.setMinorAlignment(0);
            layoutThis.setMajorAlignment(1);
            layoutThis.setMajorSpacing(0);
            layoutThis.setMinorSpacing(0);
            layoutThis.setHorizontal(false);
            this.setLayoutManager((LayoutManager)layoutThis);
            this.setAlpha(new Integer(ActivityPartitionEditPart.this.store.getInt("org.eclipse.papyrus.uml.diagram.activity.StructuredActivityNode.alpha.activityPartition")));
            ActivityPartitionEditPart.this.store.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("org.eclipse.papyrus.uml.diagram.activity.StructuredActivityNode.alpha.activityPartition".equals(event.getProperty()) && ActivityPartitionEditPart.this.getFigure() != null) {
                        ActivityPartitionDescriptor.this.setAlpha(((ActivityPartitionDescriptor)ActivityPartitionDescriptor.this).ActivityPartitionEditPart.this.store.getInt("org.eclipse.papyrus.uml.diagram.activity.StructuredActivityNode.alpha.activityPartition"));
                    }
                }
            });
            this.setFill(true);
            this.setOutline(false);
            this.setBorder(this.createBorder0());
            this.createContents();
            this.stereotypeHelper = new StereotypeFigureHelper((IFigure)this){

                public IMapMode getMapMode() {
                    return ActivityPartitionEditPart.this.getMapMode();
                }

                public Object getStereotypeRectangleConstraint() {
                    FlowLayoutAdvancedConstraint constraint = new FlowLayoutAdvancedConstraint();
                    constraint.setFill(false);
                    return constraint;
                }

                protected void init() {
                    super.init();
                    this.setBottomInset(0);
                    this.setLeftInset(0);
                    this.setTopInset(0);
                    this.setRightInset(0);
                    this.setStereotypeContainerFilled(true);
                }
            };
        }

        protected void outlineShape(Graphics graphics) {
            float lineInset = Math.max(1.0f, this.getLineWidthFloat()) / 2.0f;
            int inset1 = (int)Math.floor(lineInset);
            int inset2 = (int)Math.ceil(lineInset);
            Rectangle r = Rectangle.SINGLETON.setBounds(this.getBounds());
            r.x += inset1;
            r.y += inset1;
            r.width -= inset1 + inset2;
            r.height -= inset1 + inset2;
            graphics.drawRectangle(r);
            PointList points = new PointList(4);
            points.addPoint(r.getBottomLeft());
            points.addPoint(r.getTopLeft());
            points.addPoint(r.getTopRight());
            points.addPoint(r.getBottomRight());
            graphics.drawPolyline(points);
        }

        private void createContents() {
            this.fFigureCompartmentLabelActivityPartition = new RectangleFigure();
            this.fFigureCompartmentLabelActivityPartition.setOutline(false);
            this.fFigureCompartmentLabelActivityPartition.setLineWidth(0);
            this.fFigureCompartmentLabelActivityPartition.setBorder(this.createBorder1());
            FlowLayoutAdvancedConstraint constraintFFigureCompartmentLabelActivityPartition = new FlowLayoutAdvancedConstraint();
            constraintFFigureCompartmentLabelActivityPartition.setHasMinsize(true);
            this.add((IFigure)this.fFigureCompartmentLabelActivityPartition, constraintFFigureCompartmentLabelActivityPartition);
            FlowLayout layoutFFigureCompartmentLabelActivityPartition = new FlowLayout();
            layoutFFigureCompartmentLabelActivityPartition.setStretchMinorAxis(true);
            layoutFFigureCompartmentLabelActivityPartition.setMinorAlignment(0);
            layoutFFigureCompartmentLabelActivityPartition.setMajorAlignment(0);
            layoutFFigureCompartmentLabelActivityPartition.setMajorSpacing(0);
            layoutFFigureCompartmentLabelActivityPartition.setMinorSpacing(0);
            layoutFFigureCompartmentLabelActivityPartition.setHorizontal(true);
            this.fFigureCompartmentLabelActivityPartition.setLayoutManager((LayoutManager)layoutFFigureCompartmentLabelActivityPartition);
            this.fPartitionLabel = new CenteredWrappedLabel();
            this.fFigureCompartmentLabelActivityPartition.add((IFigure)this.fPartitionLabel);
            this.fActivityPartitionCompartment = new RectangleFigure();
            this.fActivityPartitionCompartment.setFill(false);
            this.fActivityPartitionCompartment.setOutline(false);
            this.fActivityPartitionCompartment.setLineWidth(0);
            FlowLayoutAdvancedConstraint constraintFActivityPartitionCompartment = new FlowLayoutAdvancedConstraint();
            constraintFActivityPartitionCompartment.setFill(true);
            this.add((IFigure)this.fActivityPartitionCompartment, constraintFActivityPartitionCompartment);
        }

        private Border createBorder0() {
            LinesBorder result = new LinesBorder();
            result.setSides(13);
            return result;
        }

        private Border createBorder1() {
            LinesBorder result = new LinesBorder();
            result.setSides(32);
            result.setLeftInset(5);
            result.setRightInset(5);
            result.setTopInset(5);
            result.setBottomInset(5);
            return result;
        }

        public RectangleFigure getActivityPartitionCompartment() {
            return this.fActivityPartitionCompartment;
        }

        public CenteredWrappedLabel getPartitionLabel() {
            return this.fPartitionLabel;
        }

        public RectangleFigure getFigureCompartmentLabelActivityPartition() {
            return this.fFigureCompartmentLabelActivityPartition;
        }

        public void setStereotypeDisplay(String stereotypes, Image image) {
            this.stereotypeHelper.setStereotypeDisplay(stereotypes, image);
            this.layout();
        }

        public void setStereotypePropertiesInBrace(String stereotypeProperties) {
            this.stereotypeHelper.setStereotypePropertiesInBrace(stereotypeProperties);
            this.layout();
        }

        public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
            this.stereotypeHelper.setStereotypePropertiesInCompartment(stereotypeProperties);
            this.layout();
        }

        @Deprecated
        public Label getStereotypesLabel() {
            return null;
        }
    }
}

