/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.activity.navigator.UMLAbstractNavigatorItem;
import org.eclipse.papyrus.uml.diagram.activity.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.activity.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.activity.part.Messages;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class UMLNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public UMLNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    private Object[] getViewChildrenForInputPinInSendSigActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3062_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3062_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDataStoreNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DataStoreNode_3078_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DataStoreNode_3078_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInSendSigActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3055_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3055_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConditionalNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConditionalNode_3069_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConditionalNode_3069_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForLoopNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_LoopNode_3071_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_LoopNode_3071_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForAcceptEventActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_AcceptEventAction_3063_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_AcceptEventAction_3063_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3064));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCreateObjectActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CreateObjectAction_3086_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CreateObjectAction_3086_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3087));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForSendSignalActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_SendSignalAction_3052_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_SendSignalAction_3052_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3053));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3054));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3055));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3060));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3061));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3062));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInitialNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InitialNode_3004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InitialNode_3004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentEditPartCN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_3080_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_3080_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOpaqueActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OpaqueAction_3007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OpaqueAction_3007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInSendSigActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3053_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3053_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInSendSigActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3061_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3061_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCallOperationActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CallOperationAction_3010_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CallOperationAction_3010_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3025));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3026));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3027));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForExpansionNodeAsInEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExpansionNode_3074_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExpansionNode_3074_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInAddVariableValueActionAsInsertAtEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3100_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3100_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForObjectFlowEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ObjectFlow_4003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ObjectFlow_4003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ObjectFlow_4003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3025));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3026));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3027));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3038));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3039));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3040));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3041));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3078));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3046));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3047));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3048));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3049));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3050));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3051));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3053));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3054));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3055));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3060));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3061));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3062));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3064));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3077));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3074));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3075));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3084));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3087));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3089));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3090));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3092));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3093));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3094));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3096));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3098));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3100));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3101));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3103));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3104));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3025));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3026));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3027));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3038));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3039));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3040));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3041));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3078));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3046));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3047));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3048));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3049));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3050));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3051));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3053));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3054));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3055));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3060));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3061));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3062));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3064));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3077));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3074));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3075));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3084));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3087));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3089));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3090));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3092));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3093));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3094));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3096));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3098));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3100));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3101));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3103));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3104));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInOpaqueActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3013_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3013_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInSendObjActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3050_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3050_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForExpansionNodeAsOutEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExpansionNode_3075_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExpansionNode_3075_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForBroadcastSignalActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_BroadcastSignalAction_3102_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_BroadcastSignalAction_3102_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3103));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActivityParameterNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActivityParameterNode_3059_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActivityParameterNode_3059_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForTimeConstraintAsLocalPrecondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeConstraint_3036_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInSendSigActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3060_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3060_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInAddStructuralFeatureValueActionAsValueEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3093_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3093_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInCallOpActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3023_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3023_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInReadVariableActionAsResultEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3098_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3098_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationConstraintAsLocalPostcondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_3035_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInCallOpActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3025_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3025_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForForkNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ForkNode_3040_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ForkNode_3040_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionLocalPostconditionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionLocalPostcondition_4002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionLocalPostcondition_4002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3034));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3035));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3036));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3037));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3032));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3033));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInSendObjActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3051_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3051_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForAddStructuralFeatureValueActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_AddStructuralFeatureValueAction_3091_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_AddStructuralFeatureValueAction_3091_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3092));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3093));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3094));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValueSpecificationActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValueSpecificationAction_3076_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValueSpecificationAction_3076_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3077));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForTimeConstraintAsLocalPostcondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeConstraint_3037_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActivityDiagramEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup links = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        if (!links.isEmpty()) {
            result.add(links);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInCallOpActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3021_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3021_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMergeNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_MergeNode_3039_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_MergeNode_3039_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCentralBufferNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CentralBufferNode_3104_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CentralBufferNode_3104_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInCallOpActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3024_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3024_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInCallOpActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3026_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3026_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForSendObjectActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_SendObjectAction_3042_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_SendObjectAction_3042_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3046));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3047));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3048));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3049));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3050));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3051));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInSendObjActAsReqEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3048_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3048_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionLocalPreconditionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionLocalPrecondition_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionLocalPrecondition_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3034));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3035));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3036));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3037));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3032));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3033));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForFlowFinalNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_FlowFinalNode_3006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_FlowFinalNode_3006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInCallBeActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3019_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3019_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForControlFlowEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ControlFlow_4004_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ControlFlow_4004_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ControlFlow_4004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3025));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3026));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3027));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3038));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3039));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3040));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3041));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3078));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3046));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3047));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3048));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3049));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3050));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3051));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3053));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3054));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3055));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3060));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3061));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3062));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3064));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3077));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3074));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3075));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3084));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3087));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3089));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3090));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3092));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3093));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3094));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3096));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3098));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3100));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3101));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3103));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3104));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3025));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3026));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3027));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3038));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3039));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3040));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3041));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3078));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3046));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3047));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3048));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3049));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3050));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3051));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3053));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3054));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3055));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3060));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3061));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3062));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3064));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3077));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3074));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3075));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3084));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3087));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3089));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3090));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3092));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3093));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3094));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3096));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3098));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3100));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3101));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3103));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3104));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForIntervalConstraintAsLocalPostcondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_IntervalConstraint_3033_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInCallOpActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3022_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3022_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInBroadcastSignalActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3103_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3103_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActivityPartitionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActivityPartition_3067_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForIntervalConstraintAsLocalPrecondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_IntervalConstraint_3032_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentLinkEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4006_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_CommentAnnotatedElement_4006_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(2001));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3004));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3005));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3006));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3025));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3026));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3027));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3034));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3035));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3036));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3037));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3032));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3033));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3011));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3012));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3038));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3039));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3040));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3041));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3078));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3046));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3047));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3048));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3049));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3050));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3051));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3053));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3054));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3055));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3060));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3061));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3062));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3064));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3077));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3074));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3075));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3067));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3068));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3080));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3084));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3083));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3087));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3089));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3090));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3092));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3093));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3094));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3096));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3098));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3100));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3101));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3103));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3104));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3080));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForJoinNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_JoinNode_3041_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_JoinNode_3041_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInOpaqueActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3016_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3016_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForReadSelfActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ReadSelfAction_3081_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ReadSelfAction_3081_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3084));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForExpansionRegionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExpansionRegion_3070_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExpansionRegion_3070_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3074));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3075));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForExceptionHandlerEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExceptionHandler_4005_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExceptionHandler_4005_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ExceptionHandler_4005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3015));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3016));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3013));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3014));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3021));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3022));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3023));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3024));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3025));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3026));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3027));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3078));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3046));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3047));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3048));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3049));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3050));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3051));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3053));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3054));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3055));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3060));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3061));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3062));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3064));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3077));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3074));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3075));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3084));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3087));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3089));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3090));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3092));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3093));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3094));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3096));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3098));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3100));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3101));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3103));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3104));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3007));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3008));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3010));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3042));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3052));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3063));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3076));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3069));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3070));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3071));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3073));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3065));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3081));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3086));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3088));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3091));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3095));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3097));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3099));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3102));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInAddVariableValueActionAsValueEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3101_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3101_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActivityEditPartCN(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Activity_3083_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7014));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3001));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7015));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3002));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7016));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3003));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3004));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3005));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3006));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3007));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3008));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3010));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3034));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3035));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3036));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3037));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3032));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3033));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3011));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3012));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3038));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3039));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3040));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3041));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3078));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3042));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3052));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3059));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3063));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3076));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3069));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3070));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3071));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3073));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3065));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3067));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3068));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3080));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3081));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3083));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3086));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3088));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3091));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3095));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3097));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3099));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3102));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7013));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3104));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInCreateObjectActionAsResultEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3087_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3087_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInOpaqueActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3015_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3015_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForSequenceNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_SequenceNode_3073_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_SequenceNode_3073_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInCallBeActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3020_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3020_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInCallBeActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3017_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3017_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInSendObjActAsReqEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3046_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3046_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInValSpecActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3077_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3077_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInSendObjActAsReqEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3047_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3047_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForReadVariableActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ReadVariableAction_3097_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ReadVariableAction_3097_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3098));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintAsLocalPostcondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3012_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInAcceptEventActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3064_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3064_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDestroyObjectActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DestroyObjectAction_3095_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DestroyObjectAction_3095_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3096));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForReadSelfActionOutputPinEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3084_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3084_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActivityEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Activity_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7001));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3001));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7002));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3002));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7003));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3003));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3004));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3005));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3006));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3007));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3008));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3010));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3034));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3035));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3036));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3037));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3032));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3033));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3011));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3012));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3038));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3039));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3040));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3041));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3078));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3042));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3052));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3059));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3063));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3076));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3069));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3070));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3071));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3073));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3065));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3067));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3068));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3080));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3081));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3083));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3086));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3088));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3091));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3095));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3097));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3099));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3102));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(7004));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType(3104));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCallBehaviorActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CallBehaviorAction_3008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CallBehaviorAction_3008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3017));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3018));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3019));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3020));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInSendSigActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3054_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3054_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForReadStructuralFeatureActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ReadStructuralFeatureAction_3088_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ReadStructuralFeatureAction_3088_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3089));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3090));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationConstraintAsLocalPrecondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_3034_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInCallOpActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3027_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3027_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInAddStructuralFeatureValueActionAsResultEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3094_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3094_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInOpaqueActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3014_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3014_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForAddVariableValueActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_AddVariableValueAction_3099_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_AddVariableValueAction_3099_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3100));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType(3101));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintAsLocalPrecondEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_3011_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInDestroyObjectActionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3096_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3096_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInReadStructuralFeatureAsObjectEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3089_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3089_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDecisionNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DecisionNode_3038_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DecisionNode_3038_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForStructuredActivityNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_StructuredActivityNode_3065_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_StructuredActivityNode_3065_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4001));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4002));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInterruptibleActivityRegionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InterruptibleActivityRegion_3068_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForValuePinInSendObjActAsTargetEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3049_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ValuePin_3049_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForOutputPinInReadStructuralFeatureAsResultEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3090_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_OutputPin_3090_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActivityFinalNodeEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActivityFinalNode_3005_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActivityFinalNode_3005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInputPinInAddStructuralFeatureValueActionAsObjectEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3092_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InputPin_3092_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionInputPinInCallBeActEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3018_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionInputPin_3018_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4003));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4004));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4005));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType(4006));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            return result.toArray();
        }
        if (parentElement instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 3025: {
                return this.getViewChildrenForValuePinInCallOpActAsTargetEditPart(view, parentElement);
            }
            case 3100: {
                return this.getViewChildrenForInputPinInAddVariableValueActionAsInsertAtEditPart(view, parentElement);
            }
            case 3080: {
                return this.getViewChildrenForCommentEditPartCN(view, parentElement);
            }
            case 3059: {
                return this.getViewChildrenForActivityParameterNodeEditPart(view, parentElement);
            }
            case 3094: {
                return this.getViewChildrenForOutputPinInAddStructuralFeatureValueActionAsResultEditPart(view, parentElement);
            }
            case 4003: {
                return this.getViewChildrenForObjectFlowEditPart(view, parentElement);
            }
            case 3103: {
                return this.getViewChildrenForInputPinInBroadcastSignalActionEditPart(view, parentElement);
            }
            case 3090: {
                return this.getViewChildrenForOutputPinInReadStructuralFeatureAsResultEditPart(view, parentElement);
            }
            case 3008: {
                return this.getViewChildrenForCallBehaviorActionEditPart(view, parentElement);
            }
            case 3011: {
                return this.getViewChildrenForConstraintAsLocalPrecondEditPart(view, parentElement);
            }
            case 3086: {
                return this.getViewChildrenForCreateObjectActionEditPart(view, parentElement);
            }
            case 3084: {
                return this.getViewChildrenForReadSelfActionOutputPinEditPart(view, parentElement);
            }
            case 3016: {
                return this.getViewChildrenForActionInputPinInOpaqueActEditPart(view, parentElement);
            }
            case 3023: {
                return this.getViewChildrenForInputPinInCallOpActEditPart(view, parentElement);
            }
            case 4004: {
                return this.getViewChildrenForControlFlowEditPart(view, parentElement);
            }
            case 3077: {
                return this.getViewChildrenForOutputPinInValSpecActEditPart(view, parentElement);
            }
            case 3071: {
                return this.getViewChildrenForLoopNodeEditPart(view, parentElement);
            }
            case 3022: {
                return this.getViewChildrenForValuePinInCallOpActEditPart(view, parentElement);
            }
            case 4001: {
                return this.getViewChildrenForActionLocalPreconditionEditPart(view, parentElement);
            }
            case 3041: {
                return this.getViewChildrenForJoinNodeEditPart(view, parentElement);
            }
            case 3069: {
                return this.getViewChildrenForConditionalNodeEditPart(view, parentElement);
            }
            case 4002: {
                return this.getViewChildrenForActionLocalPostconditionEditPart(view, parentElement);
            }
            case 3093: {
                return this.getViewChildrenForInputPinInAddStructuralFeatureValueActionAsValueEditPart(view, parentElement);
            }
            case 3102: {
                return this.getViewChildrenForBroadcastSignalActionEditPart(view, parentElement);
            }
            case 3039: {
                return this.getViewChildrenForMergeNodeEditPart(view, parentElement);
            }
            case 3015: {
                return this.getViewChildrenForValuePinInOpaqueActEditPart(view, parentElement);
            }
            case 3098: {
                return this.getViewChildrenForOutputPinInReadVariableActionAsResultEditPart(view, parentElement);
            }
            case 3064: {
                return this.getViewChildrenForOutputPinInAcceptEventActionEditPart(view, parentElement);
            }
            case 3095: {
                return this.getViewChildrenForDestroyObjectActionEditPart(view, parentElement);
            }
            case 3033: {
                return this.getViewChildrenForIntervalConstraintAsLocalPostcondEditPart(view, parentElement);
            }
            case 3089: {
                return this.getViewChildrenForInputPinInReadStructuralFeatureAsObjectEditPart(view, parentElement);
            }
            case 4005: {
                return this.getViewChildrenForExceptionHandlerEditPart(view, parentElement);
            }
            case 3083: {
                return this.getViewChildrenForActivityEditPartCN(view, parentElement);
            }
            case 3092: {
                return this.getViewChildrenForInputPinInAddStructuralFeatureValueActionAsObjectEditPart(view, parentElement);
            }
            case 3035: {
                return this.getViewChildrenForDurationConstraintAsLocalPostcondEditPart(view, parentElement);
            }
            case 3027: {
                return this.getViewChildrenForInputPinInCallOpActAsTargetEditPart(view, parentElement);
            }
            case 3060: {
                return this.getViewChildrenForValuePinInSendSigActAsTargetEditPart(view, parentElement);
            }
            case 3054: {
                return this.getViewChildrenForValuePinInSendSigActEditPart(view, parentElement);
            }
            case 3101: {
                return this.getViewChildrenForInputPinInAddVariableValueActionAsValueEditPart(view, parentElement);
            }
            case 3087: {
                return this.getViewChildrenForOutputPinInCreateObjectActionAsResultEditPart(view, parentElement);
            }
            case 2001: {
                return this.getViewChildrenForActivityEditPart(view, parentElement);
            }
            case 3037: {
                return this.getViewChildrenForTimeConstraintAsLocalPostcondEditPart(view, parentElement);
            }
            case 3068: {
                return this.getViewChildrenForInterruptibleActivityRegionEditPart(view, parentElement);
            }
            case 3062: {
                return this.getViewChildrenForInputPinInSendSigActAsTargetEditPart(view, parentElement);
            }
            case 3055: {
                return this.getViewChildrenForInputPinInSendSigActEditPart(view, parentElement);
            }
            case 3005: {
                return this.getViewChildrenForActivityFinalNodeEditPart(view, parentElement);
            }
            case 3074: {
                return this.getViewChildrenForExpansionNodeAsInEditPart(view, parentElement);
            }
            case 4006: {
                return this.getViewChildrenForCommentLinkEditPart(view, parentElement);
            }
            case 3061: {
                return this.getViewChildrenForActionInputPinInSendSigActAsTargetEditPart(view, parentElement);
            }
            case 3004: {
                return this.getViewChildrenForInitialNodeEditPart(view, parentElement);
            }
            case 3073: {
                return this.getViewChildrenForSequenceNodeEditPart(view, parentElement);
            }
            case 3097: {
                return this.getViewChildrenForReadVariableActionEditPart(view, parentElement);
            }
            case 3076: {
                return this.getViewChildrenForValueSpecificationActionEditPart(view, parentElement);
            }
            case 3020: {
                return this.getViewChildrenForOutputPinInCallBeActEditPart(view, parentElement);
            }
            case 3019: {
                return this.getViewChildrenForInputPinInCallBeActEditPart(view, parentElement);
            }
            case 3014: {
                return this.getViewChildrenForOutputPinInOpaqueActEditPart(view, parentElement);
            }
            case 3070: {
                return this.getViewChildrenForExpansionRegionEditPart(view, parentElement);
            }
            case 3049: {
                return this.getViewChildrenForValuePinInSendObjActAsTargetEditPart(view, parentElement);
            }
            case 3047: {
                return this.getViewChildrenForActionInputPinInSendObjActAsReqEditPart(view, parentElement);
            }
            case 3065: {
                return this.getViewChildrenForStructuredActivityNodeEditPart(view, parentElement);
            }
            case 3099: {
                return this.getViewChildrenForAddVariableValueActionEditPart(view, parentElement);
            }
            case 3007: {
                return this.getViewChildrenForOpaqueActionEditPart(view, parentElement);
            }
            case 1000: {
                return this.getViewChildrenForActivityDiagramEditPart(view, parentElement);
            }
            case 3063: {
                return this.getViewChildrenForAcceptEventActionEditPart(view, parentElement);
            }
            case 3026: {
                return this.getViewChildrenForActionInputPinInCallOpActAsTargetEditPart(view, parentElement);
            }
            case 3018: {
                return this.getViewChildrenForActionInputPinInCallBeActEditPart(view, parentElement);
            }
            case 3012: {
                return this.getViewChildrenForConstraintAsLocalPostcondEditPart(view, parentElement);
            }
            case 3046: {
                return this.getViewChildrenForValuePinInSendObjActAsReqEditPart(view, parentElement);
            }
            case 3081: {
                return this.getViewChildrenForReadSelfActionEditPart(view, parentElement);
            }
            case 3006: {
                return this.getViewChildrenForFlowFinalNodeEditPart(view, parentElement);
            }
            case 3075: {
                return this.getViewChildrenForExpansionNodeAsOutEditPart(view, parentElement);
            }
            case 3048: {
                return this.getViewChildrenForInputPinInSendObjActAsReqEditPart(view, parentElement);
            }
            case 3096: {
                return this.getViewChildrenForInputPinInDestroyObjectActionEditPart(view, parentElement);
            }
            case 3088: {
                return this.getViewChildrenForReadStructuralFeatureActionEditPart(view, parentElement);
            }
            case 3038: {
                return this.getViewChildrenForDecisionNodeEditPart(view, parentElement);
            }
            case 3010: {
                return this.getViewChildrenForCallOperationActionEditPart(view, parentElement);
            }
            case 3034: {
                return this.getViewChildrenForDurationConstraintAsLocalPrecondEditPart(view, parentElement);
            }
            case 3053: {
                return this.getViewChildrenForActionInputPinInSendSigActEditPart(view, parentElement);
            }
            case 3021: {
                return this.getViewChildrenForActionInputPinInCallOpActEditPart(view, parentElement);
            }
            case 3013: {
                return this.getViewChildrenForInputPinInOpaqueActEditPart(view, parentElement);
            }
            case 3052: {
                return this.getViewChildrenForSendSignalActionEditPart(view, parentElement);
            }
            case 3091: {
                return this.getViewChildrenForAddStructuralFeatureValueActionEditPart(view, parentElement);
            }
            case 3036: {
                return this.getViewChildrenForTimeConstraintAsLocalPrecondEditPart(view, parentElement);
            }
            case 3032: {
                return this.getViewChildrenForIntervalConstraintAsLocalPrecondEditPart(view, parentElement);
            }
            case 3051: {
                return this.getViewChildrenForInputPinInSendObjActAsTargetEditPart(view, parentElement);
            }
            case 3104: {
                return this.getViewChildrenForCentralBufferNodeEditPart(view, parentElement);
            }
            case 3024: {
                return this.getViewChildrenForOutputPinInCallOpActEditPart(view, parentElement);
            }
            case 3017: {
                return this.getViewChildrenForValuePinInCallBeActEditPart(view, parentElement);
            }
            case 3067: {
                return this.getViewChildrenForActivityPartitionEditPart(view, parentElement);
            }
            case 3078: {
                return this.getViewChildrenForDataStoreNodeEditPart(view, parentElement);
            }
            case 3040: {
                return this.getViewChildrenForForkNodeEditPart(view, parentElement);
            }
            case 3050: {
                return this.getViewChildrenForActionInputPinInSendObjActAsTargetEditPart(view, parentElement);
            }
            case 3042: {
                return this.getViewChildrenForSendObjectActionEditPart(view, parentElement);
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLActivityDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<UMLNavigatorItem> result = new ArrayList<UMLNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new UMLNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

