/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallBehaviorActionParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String CALLBEHAVIORACTION_LABEL_FORMAT = "%s : %s";

    public CallBehaviorActionParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public CallBehaviorActionParser(EAttribute[] features) {
        super(features);
    }

    public CallBehaviorActionParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        if (obj instanceof CallBehaviorAction) {
            CallBehaviorAction action = (CallBehaviorAction)obj;
            String actionName = "";
            if (action.getName() != null) {
                actionName = action.getName();
            }
            String behaviorName = "";
            if (action.getBehavior() != null && action.getBehavior().getName() != null) {
                behaviorName = action.getBehavior().getName();
            }
            if ("".equals(actionName) || actionName.equals(behaviorName)) {
                return behaviorName;
            }
            return String.format(CALLBEHAVIORACTION_LABEL_FORMAT, actionName, behaviorName);
        }
        return " ";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof CallBehaviorAction) {
            CallBehaviorAction action = (CallBehaviorAction)element;
            semanticElementsBeingParsed.add(action);
            Behavior behavior = action.getBehavior();
            if (behavior != null) {
                semanticElementsBeingParsed.add(behavior);
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getCallBehaviorAction_Behavior().equals(feature);
    }
}

