/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.uml.appearance.helper.AppliedStereotypeHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class DefferedAppliedStereotypeToDisplayCommand
extends CreateEAnnotationCommand {
    protected String stereotypeList;
    protected String appliedStereotypePresentationKind;
    protected IAdaptable adapter;

    public DefferedAppliedStereotypeToDisplayCommand(TransactionalEditingDomain domain, IAdaptable adapter, String stereotypeList, String appliedStereotypepresentationKind) {
        super(domain, null, "Stereotype_Annotation");
        this.adapter = adapter;
        this.stereotypeList = stereotypeList;
        this.appliedStereotypePresentationKind = appliedStereotypepresentationKind;
    }

    public boolean canUndo() {
        return true;
    }

    protected void doExecute() {
        View view = (View)this.adapter.getAdapter(View.class);
        EObject view_element = view.getElement();
        Element element = (Element)view_element;
        Iterator listStereotype = element.getAppliedStereotypes().iterator();
        StringBuffer buffer = new StringBuffer();
        while (listStereotype.hasNext()) {
            Stereotype stereotypec = (Stereotype)listStereotype.next();
            String stereotype_string = stereotypec.getQualifiedName();
            buffer.append(stereotype_string);
            if (!listStereotype.hasNext()) continue;
            buffer.append(",");
        }
        this.stereotypeList = buffer.toString();
        String stereoList = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)view);
        if (!"".equals(stereoList)) {
            stereoList = String.valueOf(stereoList) + ",";
        }
        stereoList = String.valueOf(stereoList) + this.stereotypeList;
        EAnnotation oldAnnotation = view.getEAnnotation("Stereotype_Annotation");
        if (oldAnnotation == null) {
            oldAnnotation = this.createEAnnotation();
            this.attachEannotation(oldAnnotation, (EModelElement)view);
        }
        this.replaceEntry(oldAnnotation, "StereotypeWithQualifiedNameList", AppliedStereotypeHelper.getStereotypesQNToDisplay((EModelElement)view));
        this.replaceEntry(oldAnnotation, "StereotypeList", stereoList);
        this.replaceEntry(oldAnnotation, "Stereotype_Presentation_Kind", this.appliedStereotypePresentationKind);
        this.replaceEntry(oldAnnotation, "PropStereoDisplay", AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)view));
        this.replaceEntry(oldAnnotation, "StereotypePropertyLocation", AppliedStereotypeHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)view));
        this.replaceEannotation(view.getEAnnotation("Stereotype_Annotation"), (EModelElement)view);
    }
}

