/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.dialogs;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.papyrus.uml.diagram.common.dialogs.CustomCheckedTreeSelectionDialog;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractCheckedTreeColumnViewerSelectionDialog
extends CustomCheckedTreeSelectionDialog {
    private int nbColumns = 0;
    private String[] columnTitles = null;
    private int[] columnWidths = null;
    private CellLabelProvider[] columnCellLabelProvider;

    public AbstractCheckedTreeColumnViewerSelectionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, int style, int nbColumns) {
        super(parent, labelProvider, contentProvider, style);
        this.nbColumns = nbColumns;
        this.setSize(100, 20);
    }

    public void setColumnWidths(int[] widths) {
        Assert.isTrue((widths.length == this.nbColumns ? 1 : 0) != 0);
        this.columnWidths = widths;
    }

    public void setColumnTitles(String[] titles) {
        Assert.isTrue((titles.length == this.nbColumns ? 1 : 0) != 0);
        this.columnTitles = titles;
    }

    public void setColumnCellLabelProvider(CellLabelProvider[] providers) {
        Assert.isTrue((providers.length == this.nbColumns ? 1 : 0) != 0);
        this.columnCellLabelProvider = providers;
    }

    protected Control createDialogArea(Composite parent) {
        Control ctrl = super.createDialogArea(parent);
        int i = 0;
        while (i < this.nbColumns) {
            TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this.getTreeViewer(), 0);
            column.getColumn().setText(this.columnTitles[i]);
            column.getColumn().setWidth(this.columnWidths[i]);
            column.setLabelProvider(this.columnCellLabelProvider[i]);
            EditingSupport support = this.getEditingSupport(i);
            if (support != null) {
                column.setEditingSupport(support);
            }
            ++i;
        }
        this.getTreeViewer().getTree().setLinesVisible(true);
        this.getTreeViewer().getTree().setHeaderVisible(true);
        this.getTreeViewer().getTree().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                Tree source = (Tree)e.getSource();
                TreeItem[] item = source.getSelection();
                List<Object> expandedElements = Arrays.asList(AbstractCheckedTreeColumnViewerSelectionDialog.this.getTreeViewer().getExpandedElements());
                if (AbstractCheckedTreeColumnViewerSelectionDialog.this.getTreeViewer().isExpandable(item[0].getData())) {
                    boolean isExpanded = expandedElements.contains(item[0].getData());
                    item[0].setExpanded(!isExpanded);
                }
            }
        });
        return ctrl;
    }

    protected abstract EditingSupport getEditingSupport(int var1);
}

