/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.draw2d;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityConstrainedFlowLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.GravityDirectionType;

public class SplitEllipseLayout
extends GravityConstrainedFlowLayout {
    private int myXMargin;
    private int myYMargin;

    public SplitEllipseLayout() {
        this.setGravity(GravityDirectionType.NORTH);
        this.setIgnoreInvisibleChildren(true);
        this.setStretchMajorAxis(false);
        this.setStretchMinorAxis(false);
        this.setObserveVisibility(true);
    }

    public void layout(IFigure container) {
        int prefHeight;
        IFigure child;
        IFigure parent;
        double sin45;
        Rectangle r = container.getBounds();
        double a = r.width / 2;
        double b = r.height / 2;
        double cos45 = sin45 = Math.sqrt(2.0) / 2.0;
        double diagx = a * sin45;
        double diagy = b * cos45;
        int newxmargin = (int)(a - diagx);
        int newymargin = (int)(b - diagy);
        if (newxmargin != this.myXMargin || newymargin != this.myYMargin) {
            this.myXMargin = newxmargin;
            this.myYMargin = newymargin;
            container.setBorder((Border)new MarginBorder(this.myYMargin, this.myXMargin, this.myYMargin, this.myXMargin));
        }
        if (!(parent = container).isVisible()) {
            return;
        }
        List children = this.getChildren(parent);
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        Dimension[] maxSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        }
        int totalHeight = 0;
        int totalMinHeight = 0;
        double totalMaxHeight = 0.0;
        int prefMinSumHeight = 0;
        double prefMaxSumHeight = 0.0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(child.getPreferredSize(wHint, hHint));
            minSizes[i] = this.transposer.t(child.getMinimumSize(wHint, hHint));
            maxSizes[i] = this.transposer.t(child.getMaximumSize());
            if (this.getConstraint(child) != null) {
                double ratio = (Double)this.getConstraint(child);
                prefHeight = (int)(ratio * (double)availableHeight);
                prefHeight = Math.max(prefHeight, minSizes[i].height);
                prefSizes[i].height = prefHeight = Math.min(prefHeight, maxSizes[i].height);
            }
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            totalMaxHeight += (double)maxSizes[i].height;
            ++i;
        }
        prefMinSumHeight = (totalHeight += (numChildren - 1) * this.spacing) - (totalMinHeight += (numChildren - 1) * this.spacing);
        prefMaxSumHeight = (totalMaxHeight += (double)((numChildren - 1) * this.spacing)) - (double)totalHeight;
        int amntShrinkHeight = totalHeight - Math.max(availableHeight, totalMinHeight);
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int maxHeight = maxSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            int maxWidth = maxSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            if (this.getStretchMajorAxis() || i2 == numChildren - 1) {
                if (amntShrinkHeight > 0 && prefMinSumHeight != 0) {
                    amntShrinkCurrentHeight = (int)((long)(prefHeight - minHeight) * (long)amntShrinkHeight / (long)prefMinSumHeight);
                } else if (amntShrinkHeight < 0 && totalHeight != 0) {
                    amntShrinkCurrentHeight = (int)((double)(maxHeight - prefHeight) / prefMaxSumHeight * (double)amntShrinkHeight);
                }
            }
            int width = Math.min(prefWidth, maxWidth);
            if (this.matchWidth) {
                width = maxWidth;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.minorAlignment) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            if (newBounds.height - amntShrinkCurrentHeight > maxHeight) {
                amntShrinkCurrentHeight = newBounds.height - maxHeight;
            }
            newBounds.height -= amntShrinkCurrentHeight;
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            prefMaxSumHeight -= (double)(maxHeight - prefHeight);
            totalHeight -= prefHeight;
            y += newBounds.height + this.spacing;
            ++i2;
        }
    }

    private List getChildren(IFigure container) {
        ArrayList children = new ArrayList(container.getChildren());
        if (this.getIgnoreInvisibleChildren()) {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                IFigure f = (IFigure)iter.next();
                if (f.isVisible()) continue;
                iter.remove();
            }
        }
        if (this.isReversed()) {
            Collections.reverse(children);
        }
        return children;
    }
}

