/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;

public class PrimitiveTypeFigure
extends NodeNamedElementFigure {
    private Figure contentPane;
    private Label tagLabel;

    public PrimitiveTypeFigure() {
        super("PrimitiveType");
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(true);
        this.setLayoutManager((LayoutManager)layout);
        this.setOpaque(true);
        this.createContentPane();
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected void createContentPane() {
        this.contentPane = new Figure();
        ToolbarLayout layout = new ToolbarLayout();
        layout.setVertical(true);
        this.contentPane.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)this.contentPane);
    }

    protected int getIconLabelPosition() {
        return 1;
    }

    public Dimension getMinimumDimension() {
        int width = this.tagLabel.getTextBounds().width + 10;
        int height = this.tagLabel.getTextBounds().height + 10;
        Dimension dim = super.getMinimumDimension();
        dim.height += height;
        if (dim.width < width) {
            dim.width = width;
        }
        return dim;
    }

    protected void drawSeparateLine(Graphics graphics) {
        graphics.setForegroundColor(this.getBorderColor());
        graphics.setBackgroundColor(this.getBorderColor());
        if (this.getStereotypePropertiesContent() != null) {
            int x = this.getBounds().x;
            int w = this.getBounds().width;
            int y = this.getBounds().y + this.getNameHeight();
            graphics.drawLine(x, y, x + w, y);
        }
    }

    protected int getNameHeight() {
        return this.tagLabel.getTextBounds().height + super.getNameHeight();
    }
}

