/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteFromDiagramCommandHandler
extends GraphicalCommandHandler
implements IHandler {
    @Override
    protected Command getCommand() throws ExecutionException {
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!this.supportViews(editParts) || this.isCanonical(editParts)) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("Delete From Diagram");
        for (IGraphicalEditPart editPart : editParts) {
            command.add(editPart.getCommand((Request)new GroupRequest((Object)"delete")));
        }
        return command;
    }

    private boolean supportViews(List<IGraphicalEditPart> editParts) {
        for (IGraphicalEditPart object : editParts) {
            if (!(object instanceof GraphicalEditPart) || ((GraphicalEditPart)object).hasNotationView()) continue;
            return false;
        }
        return true;
    }

    protected boolean isCanonical(List<IGraphicalEditPart> editParts) {
        boolean isCanonical = false;
        if (!editParts.isEmpty()) {
            Iterator<IGraphicalEditPart> si = editParts.iterator();
            while (si.hasNext() && !isCanonical) {
                ConnectionEditPart connection;
                IGraphicalEditPart child = si.next();
                View view = (View)child.getAdapter(View.class);
                isCanonical = view == null || view.getElement() == null || view.getElement() instanceof View ? false : (child instanceof ConnectionEditPart ? !(connection = (ConnectionEditPart)child).isSemanticConnection() || this.isCanonical(connection.getSource()) && this.isCanonical(connection.getTarget()) : this.isCanonical((EditPart)child));
            }
        }
        return isCanonical;
    }

    protected boolean isCanonical(EditPart ep) {
        EObject eObject = (EObject)ep.getAdapter(EObject.class);
        EditPart parent = ep.getParent();
        if (eObject != null && parent != null) {
            CanonicalEditPolicy cep = (CanonicalEditPolicy)parent.getEditPolicy((Object)"Canonical");
            return cep != null && cep.isEnabled() && cep.canCreate(eObject);
        }
        return false;
    }
}

