/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.swt.graphics.Image;

public class DiagramDecorationAdapter {
    protected IDecoratorTarget decoratorTarget;
    protected IDecoration decoration;
    protected Image decorationImage;

    public DiagramDecorationAdapter(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public IDecoration getDecoration() {
        return this.decoration;
    }

    public IDecoratorTarget getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public void removeDecoration() {
        if (this.getDecoration() == null || this.getDecoratorTarget() == null) {
            return;
        }
        this.removeDecoration(this.getDecoratorTarget(), this.getDecoration());
    }

    public void removeDecoration(IDecoration decoration) {
        if (decoration == null || this.getDecoratorTarget() == null) {
            return;
        }
        this.removeDecoration(this.getDecoratorTarget(), decoration);
    }

    public IDecoration setDecoration(Image image, Decoration.PreferedPosition position, int percentageFromSource, int margin, boolean isVolatile) {
        this.decoration = this.getDecoration(this.getDecoratorTarget(), image, position, percentageFromSource, margin, isVolatile);
        this.decorationImage = image;
        return this.getDecoration();
    }

    public IDecoration setDecoration(IFigure figure, Decoration.PreferedPosition position, int percentageFromSource, int margin, boolean isVolatile) {
        this.decoration = this.getDecoration(this.getDecoratorTarget(), figure, position, percentageFromSource, margin, isVolatile);
        return this.getDecoration();
    }

    public void setDecoratorTarget(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    public Image getDecorationImage() {
        return this.decorationImage;
    }

    public Label getToolTip(String message) {
        return new Label(message, this.getDecorationImage());
    }

    public IDecoration setDecoration(org.eclipse.papyrus.infra.services.decoration.util.IDecoration idecoration, int percentageFromSource, int margin, boolean isVolatile) {
        this.decorationImage = idecoration.getDecorationImage() != null ? idecoration.getDecorationImage().createImage() : null;
        this.decoration = this.getDecoration(this.getDecoratorTarget(), this.getDecorationImage(), idecoration.getPosition(), percentageFromSource, margin, isVolatile);
        return this.getDecoration();
    }

    public void removeDecoration(IDecoratorTarget decoratorTarget, IDecoration Decoration2) {
        if (Decoration2 instanceof IFigure) {
            ((IFigure)Decoration2).getParent().remove((IFigure)Decoration2);
        }
        GraphicalEditPart ownerEditPart = (GraphicalEditPart)decoratorTarget.getAdapter(GraphicalEditPart.class);
        ownerEditPart.getViewer().getVisualPartMap().remove(Decoration2);
    }

    public IDecoration getDecoration(IDecoratorTarget decoratorTarget, Image image, Decoration.PreferedPosition position, int percentageFromSource, int margin, boolean isVolatile) {
        View view = (View)decoratorTarget.getAdapter(View.class);
        IDecoration decoration = null;
        if (view == null || view.eResource() == null || image == null) {
            return decoration;
        }
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart == null || editPart.getViewer() == null) {
            return decoration;
        }
        if (editPart instanceof GraphicalEditPart) {
            if (view instanceof Edge) {
                decoration = decoratorTarget.addConnectionDecoration(image, percentageFromSource, isVolatile);
            } else {
                if (editPart instanceof GraphicalEditPart) {
                    margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                }
                decoration = decoratorTarget.addShapeDecoration(image, this.getDirection(position), margin, isVolatile);
            }
        }
        return decoration;
    }

    private IDecoratorTarget.Direction getDirection(Decoration.PreferedPosition position) {
        switch (position) {
            case NORTH_WEST: {
                return IDecoratorTarget.Direction.NORTH_WEST;
            }
            case NORTH: {
                return IDecoratorTarget.Direction.NORTH;
            }
            case NORTH_EAST: {
                return IDecoratorTarget.Direction.NORTH_EAST;
            }
            case EAST: {
                return IDecoratorTarget.Direction.EAST;
            }
            case SOUTH_EAST: {
                return IDecoratorTarget.Direction.SOUTH_EAST;
            }
            case SOUTH: {
                return IDecoratorTarget.Direction.SOUTH;
            }
            case SOUTH_WEST: {
                return IDecoratorTarget.Direction.SOUTH_WEST;
            }
            case WEST: {
                return IDecoratorTarget.Direction.WEST;
            }
            case CENTER: {
                return IDecoratorTarget.Direction.CENTER;
            }
        }
        return IDecoratorTarget.Direction.NORTH_EAST;
    }

    public IDecoration getDecoration(IDecoratorTarget decoratorTarget, IFigure figure, Decoration.PreferedPosition position, int percentageFromSource, int margin, boolean isVolatile) {
        View view = (View)decoratorTarget.getAdapter(View.class);
        IDecoration decoration = null;
        if (view == null || view.eResource() == null || figure == null) {
            return decoration;
        }
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart == null || editPart.getViewer() == null) {
            return decoration;
        }
        if (editPart instanceof GraphicalEditPart) {
            if (view instanceof Edge) {
                decoration = decoratorTarget.addConnectionDecoration(figure, percentageFromSource, isVolatile);
            } else {
                if (editPart instanceof GraphicalEditPart) {
                    margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                }
                decoration = decoratorTarget.addShapeDecoration(figure, this.getDirection(position), margin, isVolatile);
            }
        }
        return decoration;
    }
}

