/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.providers.DiagramDecorationAdapter;
import org.eclipse.papyrus.uml.diagram.common.util.ServiceUtilsForGMF;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public abstract class ValidationDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    protected static final String KEY = "validationStatus";
    private static Map<String, IDecorator> allDecorators = new HashMap<String, IDecorator>();

    public abstract void createDecorators(IDecoratorTarget var1);

    public abstract boolean provides(IOperation var1);

    public static void refreshDecorators(View view) {
        ValidationDecoratorProvider.refreshDecorators(ViewUtil.getIdStr((View)view), TransactionUtil.getEditingDomain((EObject)view));
    }

    private static void refreshDecorators(String viewId, final TransactionalEditingDomain domain) {
        IDecorator decorator;
        IDecorator iDecorator = decorator = viewId != null ? allDecorators.get(viewId) : null;
        if (decorator == null || domain == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    domain.runExclusive(new Runnable(){

                        public void run() {
                            decorator.refresh();
                        }
                    });
                }
                catch (Exception e) {
                    Activator.log.error("Decorator refresh failure", (Throwable)e);
                }
            }
        });
    }

    public static class StatusDecorator
    extends AbstractDecorator
    implements Observer {
        private String viewId;
        private TransactionalEditingDomain editingDomain;
        private DecorationService decorationService;
        private final DiagramDecorationAdapter diagramDecorationAdapter;

        public StatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
            this.diagramDecorationAdapter = new DiagramDecorationAdapter(decoratorTarget);
            try {
                final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
                EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
                IDiagramEditDomain domain = (IDiagramEditDomain)editPart.getViewer().getEditDomain();
                ServicesRegistry serviceRegistry = ServiceUtilsForGMF.getInstance().getServiceRegistry(domain);
                this.decorationService = (DecorationService)serviceRegistry.getService(DecorationService.class);
                this.decorationService.addListener((Observer)this);
                TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                    public void run() {
                        StatusDecorator.this.viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                        StatusDecorator.this.editingDomain = TransactionUtil.getEditingDomain((EObject)view);
                    }
                });
            }
            catch (Exception e) {
                Activator.log.error("ViewID access failure", (Throwable)e);
            }
        }

        public void refresh() {
            this.removeDecoration();
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getViewer() == null) {
                return;
            }
            IDecoration deco = null;
            org.eclipse.papyrus.infra.services.decoration.util.IDecoration decoration = null;
            if (editPart instanceof GraphicalEditPart && view.getElement() != null && (decoration = this.decorationService.getDecoration((Object)view.getElement(), false)) != null) {
                decoration.setDecorationImage(this.getImageDescriptor(decoration.getSeverity()));
                if (view instanceof Edge) {
                    deco = this.diagramDecorationAdapter.setDecoration(decoration, 50, 0, true);
                } else {
                    int margin = -1;
                    if (editPart instanceof GraphicalEditPart) {
                        margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                    }
                    deco = this.diagramDecorationAdapter.setDecoration(decoration, 0, margin, true);
                }
            }
            if (deco != null) {
                this.setDecoration(deco);
                String message = decoration.getMessage();
                Label toolTip = this.diagramDecorationAdapter.getToolTip(message);
                this.getDecoration().setToolTip((IFigure)toolTip);
            }
        }

        private ImageDescriptor getImageDescriptor(int severity) {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            ImageDescriptor overlay = null;
            switch (severity) {
                case 2: {
                    overlay = sharedImages.getImageDescriptor("IMG_OBJS_ERROR_TSK");
                    break;
                }
                case 1: {
                    overlay = sharedImages.getImageDescriptor("IMG_OBJS_WARN_TSK");
                }
            }
            return overlay;
        }

        public void activate() {
            if (this.viewId == null) {
                return;
            }
            IDecorator decorator = (IDecorator)allDecorators.get(this.viewId);
            if (decorator == null) {
                allDecorators.put(this.viewId, this);
            }
        }

        public void deactivate() {
            if (this.viewId == null) {
                return;
            }
            allDecorators.remove(this.viewId);
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || this.editingDomain == null) {
                super.deactivate();
                return;
            }
            super.deactivate();
        }

        public void update(Observable o, Object arg) {
            this.refresh();
        }
    }
}

