/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinedPropertiesAtRuntimeDialog
extends Dialog {
    protected List<String> runtimeProperties;
    protected String title;
    private String message;
    private EObject elementToEdit;
    protected List<Stereotype> appliedStereotypes = null;
    private ArrayList<EAttribute> booleanMetaProperties = new ArrayList();
    private ArrayList<EAttribute> stringMetaProperties = new ArrayList();
    private ArrayList<EAttribute> enumerationMetaProperties = new ArrayList();

    protected DefinedPropertiesAtRuntimeDialog(Shell shell, String title, String message, List<String> runtimeProperties, EObject objectToEdit) {
        super(shell);
        this.runtimeProperties = runtimeProperties;
        this.title = title;
        this.elementToEdit = objectToEdit;
        this.message = message;
        if (this.elementToEdit instanceof Element) {
            this.appliedStereotypes = ((Element)this.elementToEdit).getAppliedStereotypes();
        }
        EClass currentEClass = this.elementToEdit.eClass();
        EList allAttributs = currentEClass.getEAllAttributes();
        for (EAttribute eAttribute : allAttributs) {
            if (eAttribute.isDerived() || !eAttribute.isChangeable()) continue;
            EClassifier eType = eAttribute.getEType();
            String instanceTypeName = eType.getInstanceClassName();
            if (!runtimeProperties.contains(eAttribute.getName())) continue;
            if (eType instanceof EEnum) {
                this.enumerationMetaProperties.add(eAttribute);
                continue;
            }
            if (instanceTypeName.equals(Integer.class.getCanonicalName())) {
                this.stringMetaProperties.add(eAttribute);
                continue;
            }
            if (instanceTypeName.equals("boolean")) {
                this.booleanMetaProperties.add(eAttribute);
                continue;
            }
            if (!instanceTypeName.equals(String.class.getCanonicalName())) continue;
            this.stringMetaProperties.add(eAttribute);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        Composite compo = new Composite(composite, 0);
        GridLayout compoLayout = new GridLayout(1, false);
        compo.setLayout((Layout)compoLayout);
        GridData compoData = new GridData(768);
        compoData.horizontalSpan = 2;
        compo.setLayoutData((Object)compoData);
        Label label = new Label(compo, 0);
        label.setText(this.message);
        if (this.stringMetaProperties.size() != 0) {
            this.createTextArea(composite);
        }
        if (this.enumerationMetaProperties.size() != 0) {
            this.createCombo(composite);
        }
        if (this.booleanMetaProperties.size() != 0) {
            this.createCheckBox(composite);
        }
        return composite;
    }

    protected String makeTitle(String name) {
        String title = null;
        if (name != null) {
            title = new String(name);
            String firstLetter = name.substring(0, 1);
            title = title.replaceFirst(firstLetter, firstLetter.toUpperCase());
        }
        return title;
    }

    private void createTextArea(Composite composite) {
        int iter = 0;
        while (iter < this.stringMetaProperties.size()) {
            Label label = new Label(composite, 0);
            String fieldTitle = String.valueOf(this.makeTitle(this.stringMetaProperties.get(iter).getName())) + " :";
            label.setText(fieldTitle);
            Text text = new Text(composite, 2048);
            GridData textData = new GridData(768);
            text.setLayoutData((Object)textData);
            String value = (String)this.elementToEdit.eGet((EStructuralFeature)this.stringMetaProperties.get(iter));
            text.setText(value);
            final int iterFinal = iter++;
            final Text textFinal = text;
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    DefinedPropertiesAtRuntimeDialog.this.elementToEdit.eSet((EStructuralFeature)DefinedPropertiesAtRuntimeDialog.this.stringMetaProperties.get(iterFinal), (Object)textFinal.getText());
                }
            });
        }
    }

    private void createCombo(Composite composite) {
        int iter = 0;
        while (iter < this.enumerationMetaProperties.size()) {
            Label label = new Label(composite, 0);
            String fieldTitle = String.valueOf(this.makeTitle(this.enumerationMetaProperties.get(iter).getName())) + " :";
            label.setText(fieldTitle);
            Combo combo = new Combo(composite, 8);
            EAttribute currentAttributes = this.enumerationMetaProperties.get(iter);
            EEnum eType = (EEnum)currentAttributes.getEType();
            EList literals = eType.getELiterals();
            String[] proposals = new String[literals.size() + 1];
            ArrayList<String> list = new ArrayList<String>();
            list.add("");
            proposals[0] = "";
            int i = 0;
            while (i < literals.size()) {
                proposals[i + 1] = ((EEnumLiteral)literals.get(i)).getLiteral();
                list.add(i + 1, ((EEnumLiteral)literals.get(i)).getLiteral());
                ++i;
            }
            combo.setItems(proposals);
            Object selection = this.elementToEdit.eGet((EStructuralFeature)currentAttributes);
            combo.select(list.indexOf(selection.toString()));
            GridData textData = new GridData(768);
            combo.setLayoutData((Object)textData);
            final Combo comboFinal = combo;
            final int iterFinal = iter++;
            combo.addSelectionListener(new SelectionListener((List)literals){
                private final /* synthetic */ List val$literals;
                {
                    this.val$literals = list;
                }

                public void widgetSelected(SelectionEvent e) {
                    int index = comboFinal.getSelectionIndex();
                    if (index == 0) {
                        DefinedPropertiesAtRuntimeDialog.this.elementToEdit.eUnset((EStructuralFeature)DefinedPropertiesAtRuntimeDialog.this.enumerationMetaProperties.get(iterFinal));
                    } else {
                        DefinedPropertiesAtRuntimeDialog.this.elementToEdit.eSet((EStructuralFeature)DefinedPropertiesAtRuntimeDialog.this.enumerationMetaProperties.get(iterFinal), (Object)((EEnumLiteral)this.val$literals.get(index - 1)).getInstance());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private void createCheckBox(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        composite.setLayoutData((Object)data);
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        int iter = 0;
        while (iter < this.booleanMetaProperties.size()) {
            Composite grp = new Composite(composite, 0);
            GridLayout layout2 = new GridLayout();
            layout2.numColumns = 2;
            grp.setLayout((Layout)layout2);
            Button button = new Button(grp, 0x800020);
            Label label = new Label(grp, 0);
            String fieldTitle = this.makeTitle(this.booleanMetaProperties.get(iter).getName());
            label.setText(fieldTitle);
            Boolean state = (Boolean)this.elementToEdit.eGet((EStructuralFeature)this.booleanMetaProperties.get(iter));
            button.setSelection(state.booleanValue());
            final int iterFinal = iter++;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Boolean oldValue = (Boolean)DefinedPropertiesAtRuntimeDialog.this.elementToEdit.eGet((EStructuralFeature)DefinedPropertiesAtRuntimeDialog.this.booleanMetaProperties.get(iterFinal));
                    DefinedPropertiesAtRuntimeDialog.this.elementToEdit.eSet((EStructuralFeature)DefinedPropertiesAtRuntimeDialog.this.booleanMetaProperties.get(iterFinal), (Object)(oldValue == false ? 1 : 0));
                }
            });
        }
    }
}

