/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.ui.hyperlinkshell;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.extension.commands.CreationCommandDescriptor;
import org.eclipse.papyrus.infra.core.extension.commands.CreationCommandRegistry;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommand;
import org.eclipse.papyrus.infra.core.extension.commands.ICreationCommandRegistry;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.gmfdiag.navigation.CreatedNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigationHelper;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.uml.diagram.navigation.UMLNavigationHelper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDefaultLinkDiagramTab
extends AbstractHyperLinkTab {
    private static final String CREATION_ENTRY_KEY = "CREATION_ENTRY";
    private static final String ELEMENT_TYPE_COMBO_KEY = "ELEMENT_TYPE_COMBO";
    private static final String DIAGRAM_TYPE_COMBO_KEY = "DIAGRAM_TYPE_COMBO";
    private static final String DIAGRAM_NAME_TEXT_KEY = "DIAGRAM_NAME_TEXT";
    private static final String[] COLUMN_NAMES = new String[]{"Navigation type", "Feature", "Element type", "Diagram type", "Diagram name"};
    private static final int[] COLUMN_WIDTHS = new int[]{80, 120, 120, 200, 120};
    private Map<NavigableElement, List<CreationCommandDescriptor>> possibleCreations;
    private ICommand command = null;
    private Table table;
    private EObject semanticElement;
    private Composite defaultHyperlinkComposite;

    public Composite getDefaultHyperlinkComposite() {
        return this.defaultHyperlinkComposite;
    }

    @Deprecated
    public LocalDefaultLinkDiagramTab(CTabFolder tabFolder, EObject semanticElement) {
        this.semanticElement = semanticElement;
        this.initLocalNavigableElement();
        CTabItem tbtmDefaultsHyperlinks = new CTabItem(tabFolder, 0);
        tbtmDefaultsHyperlinks.setText("Hyperlink diagram with Heuristic");
        this.defaultHyperlinkComposite = new Composite((Composite)tabFolder, 0);
        this.defaultHyperlinkComposite.setBackground(Display.getCurrent().getSystemColor(1));
        this.createArea(this.defaultHyperlinkComposite);
        tbtmDefaultsHyperlinks.setControl((Control)this.defaultHyperlinkComposite);
    }

    public LocalDefaultLinkDiagramTab() {
    }

    public void init(CTabFolder tabFolder, List<HyperLinkObject> hyperlinkObjects, EObject element) {
        super.init(tabFolder, hyperlinkObjects, element);
        this.semanticElement = element;
        this.initLocalNavigableElement();
        CTabItem tbtmDefaultsHyperlinks = new CTabItem(tabFolder, 0);
        tbtmDefaultsHyperlinks.setText("Hyperlink diagram with Heuristic");
        this.defaultHyperlinkComposite = new Composite((Composite)tabFolder, 0);
        this.defaultHyperlinkComposite.setBackground(Display.getCurrent().getSystemColor(1));
        this.createArea(this.defaultHyperlinkComposite);
        tbtmDefaultsHyperlinks.setControl((Control)this.defaultHyperlinkComposite);
    }

    public ICommand getCommand() {
        return this.command;
    }

    protected void okPressed() {
        DiResourceSet diResourceSet = EditorUtils.getDiResourceSet();
        CompositeCommand compositeCommand = new CompositeCommand("Create diagrams");
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            try {
                CCombo elementTypeCombo = (CCombo)tableItem.getData(ELEMENT_TYPE_COMBO_KEY);
                int elementTypeSelectionIndex = elementTypeCombo.getSelectionIndex();
                CCombo diagramTypeCombo = (CCombo)tableItem.getData(DIAGRAM_TYPE_COMBO_KEY);
                int diagramTypeSelectionIndex = diagramTypeCombo.getSelectionIndex();
                if (tableItem.getChecked() && elementTypeSelectionIndex != -1 && diagramTypeSelectionIndex != -1) {
                    List possibleElements = (List)tableItem.getData(CREATION_ENTRY_KEY);
                    NavigableElement navElement = (NavigableElement)possibleElements.get(elementTypeSelectionIndex);
                    CreationCommandDescriptor desc = this.possibleCreations.get(navElement).get(diagramTypeSelectionIndex);
                    Text diagramNameText = (Text)tableItem.getData(DIAGRAM_NAME_TEXT_KEY);
                    compositeCommand.add((IUndoableOperation)NavigationHelper.getLinkCreateAndOpenNavigableDiagramCommand((NavigableElement)navElement, (ICreationCommand)desc.getCommand(), (String)diagramNameText.getText(), (DiResourceSet)diResourceSet));
                }
            }
            catch (BackboneException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.command = compositeCommand;
    }

    protected Control createArea(Composite parent) {
        this.table = new Table(parent, 2592);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setBounds(10, 20, 650, 170);
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            TableColumn tableColumn = new TableColumn(this.table, 0);
            tableColumn.setText(COLUMN_NAMES[i]);
            tableColumn.setWidth(COLUMN_WIDTHS[i]);
            tableColumn.setResizable(true);
            ++i;
        }
        HashMap<NavigableGroupKey, LinkedList<NavigableElement>> successorsMap = new HashMap<NavigableGroupKey, LinkedList<NavigableElement>>();
        for (Map.Entry<NavigableElement, List<CreationCommandDescriptor>> entry : this.possibleCreations.entrySet()) {
            LinkedList<NavigableElement> successors;
            NavigableElement navElement = entry.getKey();
            NavigableGroupKey groupKey = new NavigableGroupKey();
            if (!this.semanticElement.equals(navElement.getElement())) {
                groupKey.feature = navElement.getFeature();
            }
            if (navElement instanceof CreatedNavigableElement) {
                groupKey.ancestor = ((CreatedNavigableElement)navElement).getPreviousNavigableElement();
            }
            if ((successors = (LinkedList<NavigableElement>)successorsMap.get(groupKey)) == null) {
                successors = new LinkedList<NavigableElement>();
                successorsMap.put(groupKey, successors);
            }
            successors.add(navElement);
        }
        for (Map.Entry<Object, List<Object>> entry : successorsMap.entrySet()) {
            NavigableGroupKey groupKey = (NavigableGroupKey)entry.getKey();
            List<Object> successors = entry.getValue();
            TableItem tableItem = new TableItem(this.table, 0);
            tableItem.setChecked(false);
            tableItem.setData(CREATION_ENTRY_KEY, successors);
            tableItem.setText(0, UMLNavigationHelper.getNavigationTypeFromFeature((EStructuralFeature)groupKey.feature));
            String featureString = "";
            if (groupKey.feature != null) {
                featureString = groupKey.feature.getName();
            }
            tableItem.setText(1, featureString);
            TableEditor diagramTypeEditor = new TableEditor(this.table);
            final CCombo diagramTypeCombo = new CCombo((Composite)this.table, 0);
            diagramTypeEditor.grabHorizontal = true;
            diagramTypeEditor.setEditor((Control)diagramTypeCombo, tableItem, 3);
            tableItem.setData(DIAGRAM_TYPE_COMBO_KEY, (Object)diagramTypeCombo);
            TableEditor elementTypeEditor = new TableEditor(this.table);
            final CCombo elementTypeCombo = new CCombo((Composite)this.table, 0);
            for (NavigableElement navigableElement : successors) {
                String typeName = navigableElement.getElement().eClass().getName();
                elementTypeCombo.add(typeName);
                elementTypeCombo.setData(typeName, (Object)navigableElement);
            }
            elementTypeEditor.grabHorizontal = true;
            elementTypeEditor.setEditor((Control)elementTypeCombo, tableItem, 2);
            tableItem.setData(ELEMENT_TYPE_COMBO_KEY, (Object)elementTypeCombo);
            elementTypeCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String currentTypeName = ((CCombo)e.widget).getText();
                    NavigableElement successor = (NavigableElement)elementTypeCombo.getData(currentTypeName);
                    diagramTypeCombo.clearSelection();
                    diagramTypeCombo.removeAll();
                    for (CreationCommandDescriptor desc : (List)LocalDefaultLinkDiagramTab.this.possibleCreations.get(successor)) {
                        diagramTypeCombo.add(desc.getLabel());
                    }
                    diagramTypeCombo.select(0);
                }
            });
            elementTypeCombo.select(0);
            TableEditor tableEditor = new TableEditor(this.table);
            Text text = new Text((Composite)this.table, 0);
            text.setText("DefaultName");
            tableEditor.grabHorizontal = true;
            tableEditor.setEditor((Control)text, tableItem, 4);
            tableItem.setData(DIAGRAM_NAME_TEXT_KEY, (Object)text);
        }
        parent.pack();
        return this.table;
    }

    protected void initLocalNavigableElement() {
        List navElements = NavigationHelper.getInstance().getAllNavigableElements(this.semanticElement);
        this.possibleCreations = new HashMap<NavigableElement, List<CreationCommandDescriptor>>();
        for (NavigableElement navElement : navElements) {
            EObject element = navElement.getElement();
            LinkedList<CreationCommandDescriptor> possibleCommandDescs = new LinkedList<CreationCommandDescriptor>();
            for (CreationCommandDescriptor desc : LocalDefaultLinkDiagramTab.getCreationCommandRegistry().getCommandDescriptors()) {
                if (desc.getCondition() != null && !desc.getCondition().create(element)) continue;
                possibleCommandDescs.add(desc);
            }
            if (possibleCommandDescs.isEmpty()) continue;
            this.possibleCreations.put(navElement, possibleCommandDescs);
        }
    }

    protected static ICreationCommandRegistry getCreationCommandRegistry() {
        return CreationCommandRegistry.getInstance((String)"org.eclipse.papyrus.infra.core");
    }

    public void setInput(List<HyperLinkObject> hyperLinkObjectList) {
    }

    private class NavigableGroupKey {
        public NavigableElement ancestor = null;
        public EStructuralFeature feature = null;

        private NavigableGroupKey() {
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NavigableGroupKey) {
                NavigableGroupKey grpKey = (NavigableGroupKey)obj;
                return grpKey.ancestor == this.ancestor && grpKey.feature == this.feature;
            }
            return false;
        }
    }
}

