/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.composite.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.composite.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ConnectorReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connector)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ConnectorEnd) || !(this.newEnd instanceof ConnectorEnd)) {
            return false;
        }
        if (this.getLink().getEnds().size() != 1) {
            return false;
        }
        ConnectorEnd target = (ConnectorEnd)this.getLink().getEnds().get(0);
        if (!(this.getLink().eContainer() instanceof StructuredClassifier)) {
            return false;
        }
        StructuredClassifier container = (StructuredClassifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistConnector_4013(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ConnectorEnd) || !(this.newEnd instanceof ConnectorEnd)) {
            return false;
        }
        if (this.getLink().getEnds().size() != 1) {
            return false;
        }
        ConnectorEnd source = (ConnectorEnd)this.getLink().getEnds().get(0);
        if (!(this.getLink().eContainer() instanceof StructuredClassifier)) {
            return false;
        }
        StructuredClassifier container = (StructuredClassifier)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistConnector_4013(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().getEnds().remove((Object)this.getOldSource());
        this.getLink().getEnds().add((Object)this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getEnds().remove((Object)this.getOldTarget());
        this.getLink().getEnds().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Connector getLink() {
        return (Connector)this.getElementToEdit();
    }

    protected ConnectorEnd getOldSource() {
        return (ConnectorEnd)this.oldEnd;
    }

    protected ConnectorEnd getNewSource() {
        return (ConnectorEnd)this.newEnd;
    }

    protected ConnectorEnd getOldTarget() {
        return (ConnectorEnd)this.oldEnd;
    }

    protected ConnectorEnd getNewTarget() {
        return (ConnectorEnd)this.newEnd;
    }
}

