/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.part;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.profile.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLDiagramUpdater {
    public static List<UMLNodeDescriptor> getSemanticChildren(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return UMLDiagramUpdater.getProfile_1000SemanticChildren(view);
            }
            case 1012: {
                return UMLDiagramUpdater.getPackage_1012SemanticChildren(view);
            }
            case 1005: {
                return UMLDiagramUpdater.getPackagePackageableElementCompartment_1005SemanticChildren(view);
            }
            case 11: {
                return UMLDiagramUpdater.getPackagePackageableElementCompartment_11SemanticChildren(view);
            }
            case 1042: {
                return UMLDiagramUpdater.getProfileProfilePackageableElementCompartment_1042SemanticChildren(view);
            }
            case 1051: {
                return UMLDiagramUpdater.getProfileProfilePackageableElementCompartment_1051SemanticChildren(view);
            }
            case 1071: {
                return UMLDiagramUpdater.getStereotypeAttributeCompartment_1071SemanticChildren(view);
            }
            case 1052: {
                return UMLDiagramUpdater.getStereotypeAttributeCompartment_1052SemanticChildren(view);
            }
            case 1019: {
                return UMLDiagramUpdater.getStereotypeOperationCompartment_1019SemanticChildren(view);
            }
            case 1053: {
                return UMLDiagramUpdater.getStereotypeOperationCompartment_1053SemanticChildren(view);
            }
            case 1057: {
                return UMLDiagramUpdater.getModelModelElementCompartment_1057SemanticChildren(view);
            }
            case 1058: {
                return UMLDiagramUpdater.getModelModelElementCompartment_1058SemanticChildren(view);
            }
            case 1062: {
                return UMLDiagramUpdater.getEnumerationEnumerationEnumerationLiteral_1062SemanticChildren(view);
            }
            case 1063: {
                return UMLDiagramUpdater.getEnumerationEnumerationEnumerationLiteral_1063SemanticChildren(view);
            }
            case 1067: {
                return UMLDiagramUpdater.getDataTypeDataTypeAttributeCompartment_1067SemanticChildren(view);
            }
            case 1069: {
                return UMLDiagramUpdater.getDataTypeDataTypeAttributeCompartment_1069SemanticChildren(view);
            }
            case 1068: {
                return UMLDiagramUpdater.getDataTypeDataTypeOperationCompartment_1068SemanticChildren(view);
            }
            case 1070: {
                return UMLDiagramUpdater.getDataTypeDataTypeOperationCompartment_1070SemanticChildren(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<UMLNodeDescriptor> getProfile_1000SemanticChildren(View view) {
        int visualID;
        if (!view.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (PackageableElement childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 2014) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 2015) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1031) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1014) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 2005) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1030) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 2007) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 2006) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 2009) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 2010) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (PackageableElement childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1026) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (PackageableElement childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1002) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        Resource resource = modelElement.eResource();
        Iterator<EObject> semanticIterator = UMLDiagramUpdater.getPhantomNodesIterator(resource);
        while (semanticIterator.hasNext()) {
            EObject childElement = semanticIterator.next();
            if (childElement == modelElement || UMLVisualIDRegistry.getNodeVisualID(view, childElement) != 2016) continue;
            result.add(new UMLNodeDescriptor(childElement, 2016));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getPackage_1012SemanticChildren(View view) {
        if (!view.isSetElement()) {
            return Collections.EMPTY_LIST;
        }
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (PackageableElement childElement : modelElement.getPackagedElements()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1012) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getPackagePackageableElementCompartment_1005SemanticChildren(View view) {
        int visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Package modelElement = (Package)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1007) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 1027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1024) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1012) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1028) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3025) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3026) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 3027) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getPackagePackageableElementCompartment_11SemanticChildren(View view) {
        int visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Package modelElement = (Package)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1007) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 1027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1024) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1012) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1028) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3025) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3026) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 3027) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getProfileProfilePackageableElementCompartment_1042SemanticChildren(View view) {
        int visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Profile modelElement = (Profile)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Stereotype childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1023) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 1027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1024) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1012) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1028) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3025) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3026) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 3028) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1007) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getProfileProfilePackageableElementCompartment_1051SemanticChildren(View view) {
        int visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Profile modelElement = (Profile)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Stereotype childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1023) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 1027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1024) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1012) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1028) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3025) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3026) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 3028) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1007) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getStereotypeAttributeCompartment_1071SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3002) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getStereotypeAttributeCompartment_1052SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3002) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getStereotypeOperationCompartment_1019SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3020) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getStereotypeOperationCompartment_1053SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3020) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getModelModelElementCompartment_1057SemanticChildren(View view) {
        int visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Model modelElement = (Model)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1007) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 1027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1024) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1012) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1028) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3025) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3026) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 3027) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getModelModelElementCompartment_1058SemanticChildren(View view) {
        int visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Model modelElement = (Model)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1007) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID == 1027) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1024) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1012) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 1028) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3025) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID == 3026) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (visualID != 3027) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getEnumerationEnumerationEnumerationLiteral_1062SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Enumeration modelElement = (Enumeration)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (EnumerationLiteral childElement : modelElement.getOwnedLiterals()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1037) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getEnumerationEnumerationEnumerationLiteral_1063SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Enumeration modelElement = (Enumeration)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (EnumerationLiteral childElement : modelElement.getOwnedLiterals()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 1037) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getDataTypeDataTypeAttributeCompartment_1067SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3018) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getDataTypeDataTypeAttributeCompartment_1069SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3018) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getDataTypeDataTypeOperationCompartment_1068SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3019) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public static List<UMLNodeDescriptor> getDataTypeDataTypeOperationCompartment_1070SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            int visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (visualID != 3019) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static Iterator<EObject> getPhantomNodesIterator(Resource resource) {
        return resource.getAllContents();
    }

    public static List<UMLLinkDescriptor> getContainedLinks(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                return UMLDiagramUpdater.getProfile_1000ContainedLinks(view);
            }
            case 2014: {
                return UMLDiagramUpdater.getDependency_2014ContainedLinks(view);
            }
            case 2015: {
                return UMLDiagramUpdater.getAssociation_2015ContainedLinks(view);
            }
            case 1026: {
                return UMLDiagramUpdater.getStereotype_1026ContainedLinks(view);
            }
            case 1031: {
                return UMLDiagramUpdater.getClass_1031ContainedLinks(view);
            }
            case 1002: {
                return UMLDiagramUpdater.getComment_1002ContainedLinks(view);
            }
            case 1014: {
                return UMLDiagramUpdater.getConstraint_1014ContainedLinks(view);
            }
            case 2005: {
                return UMLDiagramUpdater.getModel_2005ContainedLinks(view);
            }
            case 1030: {
                return UMLDiagramUpdater.getProfile_1030ContainedLinks(view);
            }
            case 2007: {
                return UMLDiagramUpdater.getPackage_2007ContainedLinks(view);
            }
            case 2006: {
                return UMLDiagramUpdater.getEnumeration_2006ContainedLinks(view);
            }
            case 2009: {
                return UMLDiagramUpdater.getPrimitiveType_2009ContainedLinks(view);
            }
            case 2010: {
                return UMLDiagramUpdater.getDataType_2010ContainedLinks(view);
            }
            case 2016: {
                return UMLDiagramUpdater.getDiagram_2016ContainedLinks(view);
            }
            case 3026: {
                return UMLDiagramUpdater.getPrimitiveType_3026ContainedLinks(view);
            }
            case 3019: {
                return UMLDiagramUpdater.getOperation_3019ContainedLinks(view);
            }
            case 1037: {
                return UMLDiagramUpdater.getEnumerationLiteral_1037ContainedLinks(view);
            }
            case 3018: {
                return UMLDiagramUpdater.getProperty_3018ContainedLinks(view);
            }
            case 3002: {
                return UMLDiagramUpdater.getProperty_3002ContainedLinks(view);
            }
            case 3020: {
                return UMLDiagramUpdater.getOperation_3020ContainedLinks(view);
            }
            case 1023: {
                return UMLDiagramUpdater.getStereotype_1023ContainedLinks(view);
            }
            case 3028: {
                return UMLDiagramUpdater.getClass_3028ContainedLinks(view);
            }
            case 1007: {
                return UMLDiagramUpdater.getComment_1007ContainedLinks(view);
            }
            case 1027: {
                return UMLDiagramUpdater.getModel_1027ContainedLinks(view);
            }
            case 1024: {
                return UMLDiagramUpdater.getProfile_1024ContainedLinks(view);
            }
            case 1012: {
                return UMLDiagramUpdater.getPackage_1012ContainedLinks(view);
            }
            case 1028: {
                return UMLDiagramUpdater.getConstraint_1028ContainedLinks(view);
            }
            case 3025: {
                return UMLDiagramUpdater.getEnumeration_3025ContainedLinks(view);
            }
            case 3027: {
                return UMLDiagramUpdater.getDataType_3027ContainedLinks(view);
            }
            case 1013: {
                return UMLDiagramUpdater.getExtension_1013ContainedLinks(view);
            }
            case 4001: {
                return UMLDiagramUpdater.getAssociation_4001ContainedLinks(view);
            }
            case 1045: {
                return UMLDiagramUpdater.getProfileApplication_1045ContainedLinks(view);
            }
            case 4019: {
                return UMLDiagramUpdater.getAssociation_4019ContainedLinks(view);
            }
            case 4002: {
                return UMLDiagramUpdater.getGeneralization_4002ContainedLinks(view);
            }
            case 4008: {
                return UMLDiagramUpdater.getDependency_4008ContainedLinks(view);
            }
            case 4018: {
                return UMLDiagramUpdater.getDependency_4018ContainedLinks(view);
            }
            case 1064: {
                return UMLDiagramUpdater.getElementImport_1064ContainedLinks(view);
            }
            case 1065: {
                return UMLDiagramUpdater.getPackageImport_1065ContainedLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getIncomingLinks(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 2014: {
                return UMLDiagramUpdater.getDependency_2014IncomingLinks(view);
            }
            case 2015: {
                return UMLDiagramUpdater.getAssociation_2015IncomingLinks(view);
            }
            case 1026: {
                return UMLDiagramUpdater.getStereotype_1026IncomingLinks(view);
            }
            case 1031: {
                return UMLDiagramUpdater.getClass_1031IncomingLinks(view);
            }
            case 1002: {
                return UMLDiagramUpdater.getComment_1002IncomingLinks(view);
            }
            case 1014: {
                return UMLDiagramUpdater.getConstraint_1014IncomingLinks(view);
            }
            case 2005: {
                return UMLDiagramUpdater.getModel_2005IncomingLinks(view);
            }
            case 1030: {
                return UMLDiagramUpdater.getProfile_1030IncomingLinks(view);
            }
            case 2007: {
                return UMLDiagramUpdater.getPackage_2007IncomingLinks(view);
            }
            case 2006: {
                return UMLDiagramUpdater.getEnumeration_2006IncomingLinks(view);
            }
            case 2009: {
                return UMLDiagramUpdater.getPrimitiveType_2009IncomingLinks(view);
            }
            case 2010: {
                return UMLDiagramUpdater.getDataType_2010IncomingLinks(view);
            }
            case 2016: {
                return UMLDiagramUpdater.getDiagram_2016IncomingLinks(view);
            }
            case 3026: {
                return UMLDiagramUpdater.getPrimitiveType_3026IncomingLinks(view);
            }
            case 3019: {
                return UMLDiagramUpdater.getOperation_3019IncomingLinks(view);
            }
            case 1037: {
                return UMLDiagramUpdater.getEnumerationLiteral_1037IncomingLinks(view);
            }
            case 3018: {
                return UMLDiagramUpdater.getProperty_3018IncomingLinks(view);
            }
            case 3002: {
                return UMLDiagramUpdater.getProperty_3002IncomingLinks(view);
            }
            case 3020: {
                return UMLDiagramUpdater.getOperation_3020IncomingLinks(view);
            }
            case 1023: {
                return UMLDiagramUpdater.getStereotype_1023IncomingLinks(view);
            }
            case 3028: {
                return UMLDiagramUpdater.getClass_3028IncomingLinks(view);
            }
            case 1007: {
                return UMLDiagramUpdater.getComment_1007IncomingLinks(view);
            }
            case 1027: {
                return UMLDiagramUpdater.getModel_1027IncomingLinks(view);
            }
            case 1024: {
                return UMLDiagramUpdater.getProfile_1024IncomingLinks(view);
            }
            case 1012: {
                return UMLDiagramUpdater.getPackage_1012IncomingLinks(view);
            }
            case 1028: {
                return UMLDiagramUpdater.getConstraint_1028IncomingLinks(view);
            }
            case 3025: {
                return UMLDiagramUpdater.getEnumeration_3025IncomingLinks(view);
            }
            case 3027: {
                return UMLDiagramUpdater.getDataType_3027IncomingLinks(view);
            }
            case 1013: {
                return UMLDiagramUpdater.getExtension_1013IncomingLinks(view);
            }
            case 4001: {
                return UMLDiagramUpdater.getAssociation_4001IncomingLinks(view);
            }
            case 1045: {
                return UMLDiagramUpdater.getProfileApplication_1045IncomingLinks(view);
            }
            case 4019: {
                return UMLDiagramUpdater.getAssociation_4019IncomingLinks(view);
            }
            case 4002: {
                return UMLDiagramUpdater.getGeneralization_4002IncomingLinks(view);
            }
            case 4008: {
                return UMLDiagramUpdater.getDependency_4008IncomingLinks(view);
            }
            case 4018: {
                return UMLDiagramUpdater.getDependency_4018IncomingLinks(view);
            }
            case 1064: {
                return UMLDiagramUpdater.getElementImport_1064IncomingLinks(view);
            }
            case 1065: {
                return UMLDiagramUpdater.getPackageImport_1065IncomingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getOutgoingLinks(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 2014: {
                return UMLDiagramUpdater.getDependency_2014OutgoingLinks(view);
            }
            case 2015: {
                return UMLDiagramUpdater.getAssociation_2015OutgoingLinks(view);
            }
            case 1026: {
                return UMLDiagramUpdater.getStereotype_1026OutgoingLinks(view);
            }
            case 1031: {
                return UMLDiagramUpdater.getClass_1031OutgoingLinks(view);
            }
            case 1002: {
                return UMLDiagramUpdater.getComment_1002OutgoingLinks(view);
            }
            case 1014: {
                return UMLDiagramUpdater.getConstraint_1014OutgoingLinks(view);
            }
            case 2005: {
                return UMLDiagramUpdater.getModel_2005OutgoingLinks(view);
            }
            case 1030: {
                return UMLDiagramUpdater.getProfile_1030OutgoingLinks(view);
            }
            case 2007: {
                return UMLDiagramUpdater.getPackage_2007OutgoingLinks(view);
            }
            case 2006: {
                return UMLDiagramUpdater.getEnumeration_2006OutgoingLinks(view);
            }
            case 2009: {
                return UMLDiagramUpdater.getPrimitiveType_2009OutgoingLinks(view);
            }
            case 2010: {
                return UMLDiagramUpdater.getDataType_2010OutgoingLinks(view);
            }
            case 2016: {
                return UMLDiagramUpdater.getDiagram_2016OutgoingLinks(view);
            }
            case 3026: {
                return UMLDiagramUpdater.getPrimitiveType_3026OutgoingLinks(view);
            }
            case 3019: {
                return UMLDiagramUpdater.getOperation_3019OutgoingLinks(view);
            }
            case 1037: {
                return UMLDiagramUpdater.getEnumerationLiteral_1037OutgoingLinks(view);
            }
            case 3018: {
                return UMLDiagramUpdater.getProperty_3018OutgoingLinks(view);
            }
            case 3002: {
                return UMLDiagramUpdater.getProperty_3002OutgoingLinks(view);
            }
            case 3020: {
                return UMLDiagramUpdater.getOperation_3020OutgoingLinks(view);
            }
            case 1023: {
                return UMLDiagramUpdater.getStereotype_1023OutgoingLinks(view);
            }
            case 3028: {
                return UMLDiagramUpdater.getClass_3028OutgoingLinks(view);
            }
            case 1007: {
                return UMLDiagramUpdater.getComment_1007OutgoingLinks(view);
            }
            case 1027: {
                return UMLDiagramUpdater.getModel_1027OutgoingLinks(view);
            }
            case 1024: {
                return UMLDiagramUpdater.getProfile_1024OutgoingLinks(view);
            }
            case 1012: {
                return UMLDiagramUpdater.getPackage_1012OutgoingLinks(view);
            }
            case 1028: {
                return UMLDiagramUpdater.getConstraint_1028OutgoingLinks(view);
            }
            case 3025: {
                return UMLDiagramUpdater.getEnumeration_3025OutgoingLinks(view);
            }
            case 3027: {
                return UMLDiagramUpdater.getDataType_3027OutgoingLinks(view);
            }
            case 1013: {
                return UMLDiagramUpdater.getExtension_1013OutgoingLinks(view);
            }
            case 4001: {
                return UMLDiagramUpdater.getAssociation_4001OutgoingLinks(view);
            }
            case 1045: {
                return UMLDiagramUpdater.getProfileApplication_1045OutgoingLinks(view);
            }
            case 4019: {
                return UMLDiagramUpdater.getAssociation_4019OutgoingLinks(view);
            }
            case 4002: {
                return UMLDiagramUpdater.getGeneralization_4002OutgoingLinks(view);
            }
            case 4008: {
                return UMLDiagramUpdater.getDependency_4008OutgoingLinks(view);
            }
            case 4018: {
                return UMLDiagramUpdater.getDependency_4018OutgoingLinks(view);
            }
            case 1064: {
                return UMLDiagramUpdater.getElementImport_1064OutgoingLinks(view);
            }
            case 1065: {
                return UMLDiagramUpdater.getPackageImport_1065OutgoingLinks(view);
            }
        }
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getProfile_1000ContainedLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Extension_1013((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4001((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4019((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4008((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4018((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDependency_2014ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getAssociation_2015ContainedLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getStereotype_1026ContainedLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getClass_1031ContainedLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getComment_1002ContainedLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElement_1022(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getConstraint_1014ContainedLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getModel_2005ContainedLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Extension_1013((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4001((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4019((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4008((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4018((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfile_1030ContainedLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Extension_1013((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4001((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4019((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4008((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4018((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getPackage_2007ContainedLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Extension_1013(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4001(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ProfileApplication_1045(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4019(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4008(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4018(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getEnumeration_2006ContainedLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getPrimitiveType_2009ContainedLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDataType_2010ContainedLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDiagram_2016ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getPrimitiveType_3026ContainedLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getOperation_3019ContainedLinks(View view) {
        Operation modelElement = (Operation)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getEnumerationLiteral_1037ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getProperty_3018ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getProperty_3002ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getOperation_3020ContainedLinks(View view) {
        Operation modelElement = (Operation)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getStereotype_1023ContainedLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getClass_3028ContainedLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getComment_1007ContainedLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElement_1022(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getModel_1027ContainedLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Extension_1013((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4001((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4019((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4008((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4018((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfile_1024ContainedLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Extension_1013((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4001((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4019((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4008((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4018((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getPackage_1012ContainedLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Extension_1013(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4001(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ProfileApplication_1045(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Association_4019(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4008(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Dependency_4018(modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getConstraint_1028ContainedLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getEnumeration_3025ContainedLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDataType_3027ContainedLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getExtension_1013ContainedLinks(View view) {
        Extension modelElement = (Extension)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getAssociation_4001ContainedLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfileApplication_1045ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getAssociation_4019ContainedLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getGeneralization_4002ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getDependency_4008ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getDependency_4018ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getElementImport_1064ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getPackageImport_1065ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getDependency_2014IncomingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getAssociation_2015IncomingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getStereotype_1026IncomingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Extension_1013((Class)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getClass_1031IncomingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Extension_1013(modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getComment_1002IncomingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getConstraint_1014IncomingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getModel_2005IncomingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_PackageImport_1065((Package)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfile_1030IncomingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ProfileApplication_1045(modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_PackageImport_1065((Package)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getPackage_2007IncomingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_PackageImport_1065(modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getEnumeration_2006IncomingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getPrimitiveType_2009IncomingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getDataType_2010IncomingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getDiagram_2016IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getPrimitiveType_3026IncomingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getOperation_3019IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getEnumerationLiteral_1037IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getProperty_3018IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getProperty_3002IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getOperation_3020IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getStereotype_1023IncomingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Extension_1013((Class)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getClass_3028IncomingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Extension_1013(modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getComment_1007IncomingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getModel_1027IncomingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_PackageImport_1065((Package)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfile_1024IncomingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ProfileApplication_1045(modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_PackageImport_1065((Package)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getPackage_1012IncomingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_PackageImport_1065(modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getConstraint_1028IncomingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getEnumeration_3025IncomingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getDataType_3027IncomingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getExtension_1013IncomingLinks(View view) {
        Extension modelElement = (Extension)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getAssociation_4001IncomingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfileApplication_1045IncomingLinks(View view) {
        ProfileApplication modelElement = (ProfileApplication)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getAssociation_4019IncomingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4001((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Association_4019((Type)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Generalization_4002((Classifier)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getGeneralization_4002IncomingLinks(View view) {
        Generalization modelElement = (Generalization)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getDependency_4008IncomingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getDependency_4018IncomingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingTypeModelFacetLinks_ElementImport_1064((PackageableElement)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getElementImport_1064IncomingLinks(View view) {
        ElementImport modelElement = (ElementImport)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getPackageImport_1065IncomingLinks(View view) {
        PackageImport modelElement = (PackageImport)view.getElement();
        Map crossReferences = EcoreUtil.CrossReferencer.find((Collection)view.eResource().getResourceSet().getResources());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022((Element)modelElement, crossReferences));
        result.addAll(UMLDiagramUpdater.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014((Element)modelElement, crossReferences));
        return result;
    }

    public static List<UMLLinkDescriptor> getDependency_2014OutgoingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getAssociation_2015OutgoingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getStereotype_1026OutgoingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getClass_1031OutgoingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getComment_1002OutgoingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElement_1022(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getConstraint_1014OutgoingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getModel_2005OutgoingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfile_1030OutgoingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getPackage_2007OutgoingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ProfileApplication_1045(modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getEnumeration_2006OutgoingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getPrimitiveType_2009OutgoingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDataType_2010OutgoingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDiagram_2016OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getPrimitiveType_3026OutgoingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getOperation_3019OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getEnumerationLiteral_1037OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getProperty_3018OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getProperty_3002OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getOperation_3020OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getStereotype_1023OutgoingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getClass_3028OutgoingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getComment_1007OutgoingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElement_1022(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getModel_1027OutgoingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfile_1024OutgoingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ProfileApplication_1045((Package)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getPackage_1012OutgoingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ProfileApplication_1045(modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getConstraint_1028OutgoingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014(modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getEnumeration_3025OutgoingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDataType_3027OutgoingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getExtension_1013OutgoingLinks(View view) {
        Extension modelElement = (Extension)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getAssociation_4001OutgoingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getProfileApplication_1045OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getAssociation_4019OutgoingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4001((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Association_4019((Type)modelElement));
        result.addAll(UMLDiagramUpdater.getContainedTypeModelFacetLinks_Generalization_4002((Classifier)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_ElementImport_1064((Namespace)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_PackageImport_1065((Namespace)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getGeneralization_4002OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getDependency_4008OutgoingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getDependency_4018OutgoingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4008((NamedElement)modelElement));
        result.addAll(UMLDiagramUpdater.getOutgoingTypeModelFacetLinks_Dependency_4018((NamedElement)modelElement));
        return result;
    }

    public static List<UMLLinkDescriptor> getElementImport_1064OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public static List<UMLLinkDescriptor> getPackageImport_1065OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Extension_1013(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Extension link;
            if (!(linkObject instanceof Extension) || 1013 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Extension)linkObject))) continue;
            Class dst = link.getMetaclass();
            EList sources = link.getOwnedEnds();
            Object v0 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Property)) continue;
            Property src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Extension_1013, 1013));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Association_4001(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || 4001 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() >= 2 ? targets.get(1) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_4001, 4001));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_ProfileApplication_1045(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getProfileApplications()) {
            ProfileApplication link;
            if (!(linkObject instanceof ProfileApplication) || 1045 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ProfileApplication)linkObject))) continue;
            Profile dst = link.getAppliedProfile();
            Package src = link.getApplyingPackage();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ProfileApplication_1045, 1045));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Association_4019(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || 4019 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() >= 2 ? targets.get(1) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_4019, 4019));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Generalization_4002(Classifier container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getGeneralizations()) {
            Generalization link;
            if (!(linkObject instanceof Generalization) || 4002 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Generalization)linkObject))) continue;
            Classifier dst = link.getGeneral();
            result.add(new UMLLinkDescriptor((EObject)container, (EObject)dst, (EObject)link, UMLElementTypes.Generalization_4002, 4002));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Dependency_4008(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || 4008 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_4008, 4008));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Dependency_4018(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || 4018 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_4018, 4018));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_ElementImport_1064(Namespace container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getElementImports()) {
            ElementImport link;
            if (!(linkObject instanceof ElementImport) || 1064 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ElementImport)linkObject))) continue;
            PackageableElement dst = link.getImportedElement();
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ElementImport_1064, 1064));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_PackageImport_1065(Namespace container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackageImports()) {
            PackageImport link;
            if (!(linkObject instanceof PackageImport) || 1065 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (PackageImport)linkObject))) continue;
            Package dst = link.getImportedPackage();
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.PackageImport_1065, 1065));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Extension_1013(Class target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Extension link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getExtension_Metaclass() || !(setting.getEObject() instanceof Extension) || 1013 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Extension)setting.getEObject()))) continue;
            EList sources = link.getOwnedEnds();
            Object v0 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Property)) continue;
            Property src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Extension_1013, 1013));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Association_4001(Type target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Association link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getAssociation_EndType() || !(setting.getEObject() instanceof Association) || 4001 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)setting.getEObject()))) continue;
            EList sources = link.getEndTypes();
            Object v0 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Association_4001, 4001));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_ProfileApplication_1045(Profile target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            ProfileApplication link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getProfileApplication_AppliedProfile() || !(setting.getEObject() instanceof ProfileApplication) || 1045 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ProfileApplication)setting.getEObject()))) continue;
            Package src = link.getApplyingPackage();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.ProfileApplication_1045, 1045));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Association_4019(Type target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Association link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getAssociation_EndType() || !(setting.getEObject() instanceof Association) || 4019 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)setting.getEObject()))) continue;
            EList sources = link.getEndTypes();
            Object v0 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Association_4019, 4019));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Generalization_4002(Classifier target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Generalization link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getGeneralization_General() || !(setting.getEObject() instanceof Generalization) || 4002 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Generalization)setting.getEObject())) || !(link.eContainer() instanceof Classifier)) continue;
            Classifier container = (Classifier)link.eContainer();
            result.add(new UMLLinkDescriptor((EObject)container, (EObject)target, (EObject)link, UMLElementTypes.Generalization_4002, 4002));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Dependency_4008(NamedElement target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Dependency link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getDependency_Supplier() || !(setting.getEObject() instanceof Dependency) || 4008 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)setting.getEObject()))) continue;
            EList sources = link.getClients();
            Object v0 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Dependency_4008, 4008));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Dependency_4018(NamedElement target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Dependency link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getDependency_Supplier() || !(setting.getEObject() instanceof Dependency) || 4018 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)setting.getEObject()))) continue;
            EList sources = link.getClients();
            Object v0 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Dependency_4018, 4018));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_ElementImport_1064(PackageableElement target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            ElementImport link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getElementImport_ImportedElement() || !(setting.getEObject() instanceof ElementImport) || 1064 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ElementImport)setting.getEObject()))) continue;
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.ElementImport_1064, 1064));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_PackageImport_1065(Package target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            PackageImport link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getPackageImport_ImportedPackage() || !(setting.getEObject() instanceof PackageImport) || 1065 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (PackageImport)setting.getEObject()))) continue;
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.PackageImport_1065, 1065));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingFeatureModelFacetLinks_Comment_AnnotatedElement_1022(Element target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getComment_AnnotatedElement()) continue;
            result.add(new UMLLinkDescriptor(setting.getEObject(), (EObject)target, UMLElementTypes.CommentAnnotatedElement_1022, 1022));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014(Element target, Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection<EStructuralFeature.Setting> settings = crossReferences.get(target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getConstraint_ConstrainedElement()) continue;
            result.add(new UMLLinkDescriptor(setting.getEObject(), (EObject)target, UMLElementTypes.ConstraintConstrainedElement_4014, 4014));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Association_4001(Type source) {
        Package container = null;
        Type element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Type src;
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || 4001 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() >= 2 ? targets.get(1) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type) || (src = (Type)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_4001, 4001));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_ProfileApplication_1045(Package source) {
        Package container = null;
        Package element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getProfileApplications()) {
            ProfileApplication link;
            if (!(linkObject instanceof ProfileApplication) || 1045 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ProfileApplication)linkObject))) continue;
            Profile dst = link.getAppliedProfile();
            Package src = link.getApplyingPackage();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ProfileApplication_1045, 1045));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Association_4019(Type source) {
        Package container = null;
        Type element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Type src;
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || 4019 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() >= 2 ? targets.get(1) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type) || (src = (Type)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_4019, 4019));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Dependency_4008(NamedElement source) {
        Package container = null;
        NamedElement element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            NamedElement src;
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || 4008 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement) || (src = (NamedElement)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_4008, 4008));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Dependency_4018(NamedElement source) {
        Package container = null;
        NamedElement element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            NamedElement src;
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || 4018 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() >= 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement) || (src = (NamedElement)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_4018, 4018));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_ElementImport_1064(Namespace source) {
        Namespace container = null;
        Namespace element = source;
        while (element != null && container == null) {
            if (element instanceof Namespace) {
                container = element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getElementImports()) {
            ElementImport link;
            if (!(linkObject instanceof ElementImport) || 1064 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ElementImport)linkObject))) continue;
            PackageableElement dst = link.getImportedElement();
            Namespace src = link.getImportingNamespace();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ElementImport_1064, 1064));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_PackageImport_1065(Namespace source) {
        Namespace container = null;
        Namespace element = source;
        while (element != null && container == null) {
            if (element instanceof Namespace) {
                container = element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackageImports()) {
            PackageImport link;
            if (!(linkObject instanceof PackageImport) || 1065 != UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (PackageImport)linkObject))) continue;
            Package dst = link.getImportedPackage();
            Namespace src = link.getImportingNamespace();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.PackageImport_1065, 1065));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElement_1022(Comment source) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (Element destination : source.getAnnotatedElements()) {
            result.add(new UMLLinkDescriptor((EObject)source, (EObject)destination, UMLElementTypes.CommentAnnotatedElement_1022, 1022));
        }
        return result;
    }

    private static Collection<UMLLinkDescriptor> getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElement_4014(Constraint source) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (Element destination : source.getConstrainedElements()) {
            result.add(new UMLLinkDescriptor((EObject)source, (EObject)destination, UMLElementTypes.ConstraintConstrainedElement_4014, 4014));
        }
        return result;
    }
}

