/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.ConnectionEndpointTracker;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractMessageEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.DurationObservationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.TimeObservationLabelEditPart;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.TimeObservation;

public class ObservationLinkEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public ObservationLinkEditPart(View view) {
        super(view);
    }

    protected Connection createConnectionFigure() {
        return new ConstraintLinkDescriptor();
    }

    public ConstraintLinkDescriptor getPrimaryShape() {
        return (ConstraintLinkDescriptor)this.getFigure();
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomComponentEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new CustomConnectionEndpointEditPolicy());
    }

    public class ConstraintLinkDescriptor
    extends PolylineConnectionEx {
        public ConstraintLinkDescriptor() {
            this.setLineStyle(2);
        }
    }

    private final class CustomComponentEditPolicy
    extends SemanticEditPolicy {
        private CustomComponentEditPolicy() {
        }

        protected Command getSemanticCommand(IEditCommandRequest request) {
            ICommandProxy proxy;
            Command semanticCommand = super.getSemanticCommand(request);
            if (semanticCommand != null && semanticCommand instanceof ICommandProxy && (proxy = (ICommandProxy)semanticCommand).getICommand() instanceof CompositeTransactionalCommand) {
                CompositeTransactionalCommand compositeCommand = (CompositeTransactionalCommand)proxy.getICommand();
                final ObservationLinkEditPart link = (ObservationLinkEditPart)this.getHost();
                AbstractTransactionalCommand updateLinkSourceModelCmd = new AbstractTransactionalCommand(link.getEditingDomain(), "", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        EditPart source = link.getSource();
                        if (source instanceof TimeObservationLabelEditPart) {
                            TimeObservation timeObservation = (TimeObservation)((TimeObservationLabelEditPart)source).resolveSemanticElement();
                            timeObservation.setEvent(null);
                        } else if (source instanceof DurationObservationEditPart) {
                            DurationObservation durationObservation = (DurationObservation)((DurationObservationEditPart)source).resolveSemanticElement();
                            durationObservation.getEvents().clear();
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                compositeCommand.add((IUndoableOperation)updateLinkSourceModelCmd);
            }
            return semanticCommand;
        }
    }

    private final class CustomConnectionEndpointEditPolicy
    extends ConnectionEndpointEditPolicy {
        private CustomConnectionEndpointEditPolicy() {
        }

        protected List createSelectionHandles() {
            ArrayList<CustomConnectionEndpointHandle> list = new ArrayList<CustomConnectionEndpointHandle>();
            list.add(new CustomConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 2));
            list.add(new CustomConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 3));
            return list;
        }

        protected void showConnectionMoveFeedback(ReconnectRequest request) {
            if (request.getConnectionEditPart().getSource() instanceof TimeObservationLabelEditPart && request.getTarget() instanceof AbstractMessageEditPart) {
                return;
            }
            super.showConnectionMoveFeedback(request);
        }

        public void showSourceFeedback(Request request) {
            if ("observation reconnect source".equals(request.getType()) || "observation reconnect target".equals(request.getType())) {
                this.showConnectionMoveFeedback((ReconnectRequest)request);
            }
        }

        public void eraseSourceFeedback(Request request) {
            if ("observation reconnect source".equals(request.getType()) || "observation reconnect target".equals(request.getType())) {
                this.eraseConnectionMoveFeedback((ReconnectRequest)request);
            }
        }
    }

    private class CustomConnectionEndpointHandle
    extends ConnectionEndpointHandle {
        public CustomConnectionEndpointHandle(ConnectionEditPart owner, int endPoint) {
            super(owner, endPoint);
        }

        public CustomConnectionEndpointHandle(ConnectionEditPart owner, boolean fixed, int endPoint) {
            super(owner, fixed, endPoint);
        }

        public CustomConnectionEndpointHandle(int endPoint) {
            super(endPoint);
        }

        protected DragTracker createDragTracker() {
            if (this.isFixed()) {
                return null;
            }
            ConnectionEndpointTracker tracker = new ConnectionEndpointTracker((ConnectionEditPart)this.getOwner()){

                protected Request createTargetRequest() {
                    ReconnectRequest request = new ReconnectRequest(this.getCommandName()){

                        public boolean isMovingStartAnchor() {
                            return "observation reconnect source".equals(this.getType());
                        }
                    };
                    request.setConnectionEditPart(this.getConnectionEditPart());
                    return request;
                }
            };
            if (this.getEndPoint() == 2) {
                tracker.setCommandName("observation reconnect source");
            } else {
                tracker.setCommandName("observation reconnect target");
            }
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
    }
}

