/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequestFactory;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.uml.diagram.common.commands.DeferredCreateCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.CommonDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationObservationHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateLocatedConnectionViewCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceLinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.GeneralOrdering;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.IntervalConstraint;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.TimeObservation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDiagramDragDropEditPolicy
extends CommonDiagramDragDropEditPolicy {
    public static final String LIFELINE_MISSING = "There is no representation of lifeline {0}";
    public static final String DIALOG_TITLE = "Element missing";

    public CustomDiagramDragDropEditPolicy() {
        super((ILinkMappingHelper)SequenceLinkMappingHelper.getInstance());
    }

    protected Set<Integer> getDroppableElementVisualId() {
        HashSet<Integer> elementsVisualId = new HashSet<Integer>();
        elementsVisualId.add(3001);
        elementsVisualId.add(3006);
        elementsVisualId.add(3003);
        elementsVisualId.add(3002);
        elementsVisualId.add(2001);
        elementsVisualId.add(3005);
        elementsVisualId.add(3004);
        elementsVisualId.add(3018);
        elementsVisualId.add(4010);
        elementsVisualId.add(3007);
        elementsVisualId.add(3016);
        elementsVisualId.add(3017);
        elementsVisualId.add(3009);
        elementsVisualId.add(5006);
        elementsVisualId.add(3008);
        elementsVisualId.add(5012);
        elementsVisualId.add(4011);
        elementsVisualId.add(3024);
        elementsVisualId.add(3019);
        elementsVisualId.add(3020);
        elementsVisualId.add(3021);
        elementsVisualId.add(1000);
        elementsVisualId.add(4003);
        elementsVisualId.add(4004);
        elementsVisualId.add(4005);
        elementsVisualId.add(4006);
        elementsVisualId.add(4006);
        elementsVisualId.add(4007);
        elementsVisualId.add(4008);
        elementsVisualId.add(4009);
        elementsVisualId.add(4008);
        elementsVisualId.add(4012);
        elementsVisualId.add(3022);
        elementsVisualId.add(3017);
        elementsVisualId.add(3019);
        elementsVisualId.add(3021);
        elementsVisualId.add(3023);
        elementsVisualId.add(3020);
        elementsVisualId.add(3024);
        elementsVisualId.add(3001);
        elementsVisualId.add(-1);
        return elementsVisualId;
    }

    protected IUndoableOperation getDropObjectCommand(DropObjectsRequest dropRequest, EObject droppedObject) {
        IUndoableOperation dropObjectCommand = super.getDropObjectCommand(dropRequest, droppedObject);
        if (dropObjectCommand != null && dropObjectCommand.canExecute()) {
            return dropObjectCommand;
        }
        if (droppedObject instanceof ConnectableElement) {
            return this.doDropConnectableElement(dropRequest, (ConnectableElement)droppedObject);
        }
        return dropObjectCommand;
    }

    private IUndoableOperation doDropConnectableElement(DropObjectsRequest dropRequest, ConnectableElement droppedObject) {
        Point location = dropRequest.getLocation();
        CreateViewRequest createShapeRequest = CreateViewRequestFactory.getCreateShapeRequest((IElementType)UMLElementTypes.Lifeline_3001, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
        createShapeRequest.setLocation(location);
        CreateViewRequest.ViewDescriptor viewDescriptor = (CreateViewRequest.ViewDescriptor)createShapeRequest.getViewDescriptors().get(0);
        CreateElementRequestAdapter elementAdapter = (CreateElementRequestAdapter)viewDescriptor.getElementAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)elementAdapter.getAdapter(CreateElementRequest.class);
        createElementRequest.setParameter("Connectable Element", (Object)droppedObject);
        EditPart host = this.getHost();
        Command theRealCmd = ((IGraphicalEditPart)host).getCommand((Request)createShapeRequest);
        if (theRealCmd != null && theRealCmd.canExecute()) {
            return new CommandProxy(theRealCmd);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public IElementType getUMLElementType(int elementID) {
        return UMLElementTypes.getElementType(elementID);
    }

    public int getNodeVisualID(View containerView, EObject domainElement) {
        return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
    }

    public int getLinkWithClassVisualID(EObject domainElement) {
        return UMLVisualIDRegistry.getLinkWithClassVisualID(domainElement);
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        Point location = dropRequest.getLocation().getCopy();
        Command cmd = this.handleNodeOnMessage(semanticElement, nodeVISUALID, linkVISUALID);
        if (cmd != null) {
            return cmd;
        }
        if (nodeVISUALID != -1) {
            switch (nodeVISUALID) {
                case 3003: 
                case 3006: {
                    return this.dropExecutionSpecification((ExecutionSpecification)semanticElement, nodeVISUALID, location);
                }
                case 3022: {
                    return this.dropDestructionOccurrence((DestructionOccurrenceSpecification)semanticElement, nodeVISUALID, location);
                }
                case 3017: {
                    return this.dropStateInvariant((StateInvariant)semanticElement, nodeVISUALID, location);
                }
                case 3019: 
                case 3021: {
                    return this.dropIntervalConstraintInLifeline((IntervalConstraint)semanticElement, nodeVISUALID);
                }
                case 3020: {
                    return this.dropTimeObservationInLifeline((TimeObservation)semanticElement, nodeVISUALID);
                }
                case 3018: {
                    return this.dropCoRegion((CombinedFragment)semanticElement, nodeVISUALID, location);
                }
                case 3001: 
                case 3002: 
                case 3008: 
                case 3009: 
                case 5012: {
                    return this.dropNodeElement(semanticElement, nodeVISUALID, location);
                }
                case 3004: 
                case 3007: {
                    return this.dropCombinedFragment((CombinedFragment)semanticElement, nodeVISUALID, location);
                }
                case 3005: 
                case 3016: {
                    return this.dropCompartmentNodeElement(semanticElement, nodeVISUALID, location);
                }
            }
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        if (linkVISUALID != -1) {
            switch (linkVISUALID) {
                case 4003: 
                case 4004: 
                case 4005: 
                case 4006: 
                case 4007: 
                case 4008: 
                case 4009: {
                    return this.dropMessage(dropRequest, semanticElement, linkVISUALID);
                }
                case 4012: {
                    return this.dropGeneralOrdering(dropRequest, semanticElement, linkVISUALID);
                }
            }
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropNodeElement(Element element, int nodeVISUALID, Point location) {
        EditPart parentEditPart;
        List existingViews;
        Element parent = element.getOwner();
        if (this.getHostObject().equals(parent) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)parent, (EditPartViewer)this.getViewer())).isEmpty() && (parentEditPart = this.lookForEditPart((EObject)parent)) != null) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(parentEditPart, nodeVISUALID, location, (EObject)element));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropCombinedFragment(CombinedFragment combinedFragment, int nodeVISUALID, Point location) {
        EditPart parentEditPart;
        List existingViews;
        Element parent = combinedFragment.getOwner();
        Element parentContainer = parent.getOwner();
        if (!(parentContainer instanceof CombinedFragment)) {
            parentContainer = parent;
        }
        if (this.getHostObject().equals(parentContainer) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)parent, (EditPartViewer)this.getViewer())).isEmpty() && (parentEditPart = this.lookForEditPart((EObject)parent)) instanceof GraphicalEditPart) {
            Rectangle bounds = null;
            EList lifelines = combinedFragment.getCovereds();
            for (Lifeline lifeline : combinedFragment.getCovereds()) {
                EditPart lifelineEditPart = this.lookForEditPart((EObject)lifeline);
                if (lifelineEditPart == null) {
                    Shell shell = Display.getCurrent().getActiveShell();
                    MessageDialog.openError((Shell)shell, (String)DIALOG_TITLE, (String)NLS.bind((String)LIFELINE_MISSING, (Object)lifeline.getName()));
                    return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
                }
                if (!(lifelineEditPart instanceof GraphicalEditPart)) continue;
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)lifelineEditPart;
                Rectangle rectangle = graphicalEditPart.getFigure().getBounds().getCopy();
                graphicalEditPart.getFigure().translateToAbsolute((Translatable)rectangle);
                bounds = bounds == null ? rectangle : bounds.union(rectangle);
            }
            if (bounds == null) {
                return new ICommandProxy(this.getDefaultDropNodeCommand(parentEditPart, nodeVISUALID, location, (EObject)combinedFragment));
            }
            location.x = bounds.x;
            return new ICommandProxy(this.dropCombinedFragment(this.getHost(), nodeVISUALID, location, new Dimension(bounds.width, 100), (EObject)combinedFragment));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected ICommand dropCombinedFragment(EditPart hostEP, int nodeVISUALID, Point absoluteLocation, Dimension size, EObject droppedObject) {
        List existingViews;
        IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
        String semanticHint = null;
        if (type != null) {
            semanticHint = type.getSemanticHint();
        }
        if ((existingViews = DiagramEditPartsUtil.findViews((EObject)droppedObject, (EditPartViewer)this.getViewer())).isEmpty()) {
            EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, false, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(absoluteLocation);
            createViewRequest.setSize(size);
            Command command = hostEP.getCommand((Request)createViewRequest);
            if (createViewRequest.getNewObject() instanceof List) {
                for (Object object : (List)createViewRequest.getNewObject()) {
                    if (!(object instanceof IAdaptable)) continue;
                    DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)object, this.getHost().getViewer());
                    command.chain((Command)new ICommandProxy((ICommand)createCommand2));
                }
            }
            return new CommandProxyWithResult(command, (Object)descriptor);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private Command dropCompartmentNodeElement(Element element, int nodeVISUALID, Point location) {
        EditPart parentEditPart;
        List existingViews;
        Element parent;
        Element directParent = parent = element.getOwner();
        if (parent instanceof InteractionOperand) {
            parent = parent.getOwner();
        }
        if (this.getHostObject().equals(parent) && !(existingViews = DiagramEditPartsUtil.findViews((EObject)directParent, (EditPartViewer)this.getViewer())).isEmpty() && (parentEditPart = this.lookForEditPart((EObject)directParent)) != null) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(parentEditPart, nodeVISUALID, location, (EObject)element));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command handleNodeOnMessage(Element semanticElement, int nodeVISUALID, int linkVISUALID) {
        EList events;
        if (nodeVISUALID == -1 && linkVISUALID == -1 && semanticElement instanceof DurationObservation && (events = ((DurationObservation)semanticElement).getEvents()).size() >= 2) {
            return this.dropMessageNodeBetweenEvents(semanticElement, (Element)events.get(0), (Element)events.get(1));
        }
        if (this.isDurationConstraintHint(nodeVISUALID, linkVISUALID) && semanticElement instanceof DurationConstraint && (events = ((DurationConstraint)semanticElement).getConstrainedElements()).size() >= 2) {
            return this.dropMessageNodeBetweenEvents(semanticElement, (Element)events.get(0), (Element)events.get(1));
        }
        return null;
    }

    private Command dropMessageNodeBetweenEvents(Element droppedElement, Element event1, Element event2) {
        if (event1 instanceof MessageOccurrenceSpecification && event2 instanceof MessageOccurrenceSpecification && !event1.equals(event2)) {
            boolean endsOfSameMessage = false;
            int visualId = -1;
            if (droppedElement instanceof DurationConstraint) {
                visualId = 3023;
                endsOfSameMessage = DurationConstraintHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)event1), (OccurrenceSpecification)((OccurrenceSpecification)event2));
            } else if (droppedElement instanceof DurationObservation) {
                visualId = 3024;
                endsOfSameMessage = DurationObservationHelper.endsOfSameMessage((OccurrenceSpecification)((OccurrenceSpecification)event1), (OccurrenceSpecification)((OccurrenceSpecification)event2));
            }
            if (endsOfSameMessage) {
                Message message = ((MessageOccurrenceSpecification)event1).getMessage();
                DiagramEditPart diag = DiagramEditPartsUtil.getDiagramEditPart((EditPart)this.getHost());
                for (Object conn : diag.getConnections()) {
                    EObject connElt;
                    if (!(conn instanceof ConnectionNodeEditPart) || !message.equals(connElt = ((ConnectionNodeEditPart)conn).resolveSemanticElement())) continue;
                    for (Object child : ((ConnectionNodeEditPart)conn).getChildren()) {
                        EObject childElt;
                        if (!(child instanceof GraphicalEditPart) || !droppedElement.equals(childElt = ((GraphicalEditPart)child).resolveSemanticElement())) continue;
                        return null;
                    }
                    return this.dropNodeOnMessage((PackageableElement)droppedElement, (ConnectionNodeEditPart)conn, visualId);
                }
            }
        }
        return null;
    }

    private boolean isDurationConstraintHint(int nodeVISUALID, int linkVISUALID) {
        if (linkVISUALID != -1) {
            return false;
        }
        return nodeVISUALID == -1 || nodeVISUALID == 3008 || nodeVISUALID == 3021 || nodeVISUALID == 3023;
    }

    private Command dropNodeOnMessage(PackageableElement durationLabelElement, ConnectionNodeEditPart messageEditPart, int nodeVISUALID) {
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)durationLabelElement);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        return messageEditPart.getCommand((Request)new CreateViewRequest(descriptor));
    }

    private Command dropTimeObservationInLifeline(TimeObservation observation, int nodeVISUALID) {
        Point middlePoint;
        NamedElement occ1;
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)observation);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        cc.add(this.getHost().getCommand((Request)new CreateViewRequest(descriptor)));
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost());
        if (lifelinePart != null && (occ1 = observation.getEvent()) instanceof OccurrenceSpecification && (middlePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ1))) != null) {
            int height = this.getDefaultDropHeight(nodeVISUALID);
            Point startPoint = middlePoint.getCopy();
            if (height > 0) {
                startPoint.translate(0, -height / 2);
            }
            Rectangle newBounds = new Rectangle(startPoint, new Dimension(-1, height));
            lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
            Point parentLoc = lifelinePart.getLocation();
            newBounds.translate(parentLoc.getNegated());
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropIntervalConstraintInLifeline(IntervalConstraint constraint, int nodeVISUALID) {
        Point middlePoint;
        Element occ1;
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)constraint);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, false, this.getDiagramPreferencesHint());
        cc.add(this.getHost().getCommand((Request)new CreateViewRequest(descriptor)));
        LifelineEditPart lifelinePart = SequenceUtil.getParentLifelinePart(this.getHost());
        if (lifelinePart != null && constraint.getConstrainedElements().size() >= 2) {
            Element occ12 = (Element)constraint.getConstrainedElements().get(0);
            Element occ2 = (Element)constraint.getConstrainedElements().get(1);
            if (occ12 instanceof OccurrenceSpecification && occ2 instanceof OccurrenceSpecification) {
                Point startPoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ12));
                Point endPoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ2));
                if (startPoint != null && endPoint != null) {
                    int height = endPoint.y - startPoint.y;
                    Rectangle newBounds = null;
                    newBounds = height < 0 ? new Rectangle(endPoint, new Dimension(-1, -height)) : new Rectangle(startPoint, new Dimension(-1, height));
                    lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
                    Point parentLoc = lifelinePart.getLocation();
                    newBounds.translate(parentLoc.getNegated());
                    SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
                    cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
                    return cc;
                }
            }
        } else if (lifelinePart != null && constraint.getConstrainedElements().size() == 1 && (occ1 = (Element)constraint.getConstrainedElements().get(0)) instanceof OccurrenceSpecification && (middlePoint = SequenceUtil.findLocationOfEvent(lifelinePart, (InteractionFragment)((OccurrenceSpecification)occ1))) != null) {
            int height = this.getDefaultDropHeight(nodeVISUALID);
            Point startPoint = middlePoint.getCopy();
            if (height > 0) {
                startPoint.translate(0, -height / 2);
            }
            Rectangle newBounds = new Rectangle(startPoint, new Dimension(-1, height));
            lifelinePart.getFigure().translateToRelative((Translatable)newBounds);
            Point parentLoc = lifelinePart.getLocation();
            newBounds.translate(parentLoc.getNegated());
            SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)descriptor, newBounds);
            cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
            return cc;
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private int getDefaultDropHeight(int nodeVISUALID) {
        if (3019 == nodeVISUALID || 3020 == nodeVISUALID) {
            return 2;
        }
        return -1;
    }

    private Command dropStateInvariant(StateInvariant stateInvariant, int nodeVISUALID, Point location) {
        Lifeline lifeline = (Lifeline)stateInvariant.getCovereds().get(0);
        if (lifeline.equals(this.getHostObject())) {
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)stateInvariant));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private List<Lifeline> getLifelines(List<View> existingViews) {
        ArrayList<Lifeline> lifelines = new ArrayList<Lifeline>();
        for (View view : existingViews) {
            EObject eObject = ViewUtil.resolveSemanticElement((View)((View)view.eContainer()));
            if (!(eObject instanceof Lifeline)) continue;
            lifelines.add((Lifeline)eObject);
        }
        return lifelines;
    }

    private Command dropDestructionOccurrence(DestructionOccurrenceSpecification destructionOccurence, int nodeVISUALID, Point location) {
        List existingViews = DiagramEditPartsUtil.findViews((EObject)destructionOccurence, (EditPartViewer)this.getViewer());
        List<Lifeline> lifelines = this.getLifelines(existingViews);
        if (!lifelines.contains(this.getHostObject())) {
            Lifeline lifeline = (Lifeline)this.getHostObject();
            for (InteractionFragment ift : lifeline.getCoveredBys()) {
                DestructionOccurrenceSpecification occurrenceSpecification;
                if (!(ift instanceof DestructionOccurrenceSpecification) || !destructionOccurence.equals(occurrenceSpecification = (DestructionOccurrenceSpecification)ift)) continue;
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, location, (EObject)destructionOccurence));
            }
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropExecutionSpecification(ExecutionSpecification es, int nodeVISUALID, Point location) {
        Lifeline lifeline;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)es, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && es.getStart() != null && !es.getStart().getCovereds().isEmpty() && (lifeline = (Lifeline)es.getStart().getCovereds().get(0)).equals(this.getHostObject())) {
            IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
            String semanticHint = null;
            if (type != null) {
                semanticHint = type.getSemanticHint();
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)es);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, false, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            Rectangle bounds = this.getExecutionSpecificationBounds(es);
            if (bounds != null) {
                createViewRequest.setLocation(bounds.getLocation());
                createViewRequest.setSize(bounds.getSize());
            } else {
                createViewRequest.setLocation(location);
            }
            Command command = this.getHost().getCommand((Request)createViewRequest);
            return new ICommandProxy((ICommand)new CommandProxyWithResult(command, (Object)descriptor));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Command dropCoRegion(CombinedFragment combinedFragment, int nodeVISUALID, Point location) {
        IGraphicalEditPart hostEditpart;
        EObject element;
        List existingViews = DiagramEditPartsUtil.findViews((EObject)combinedFragment, (EditPartViewer)this.getViewer());
        if (existingViews.isEmpty() && (element = (hostEditpart = (IGraphicalEditPart)this.getHost()).getNotationView().getElement()) instanceof Lifeline) {
            IHintedType type = (IHintedType)this.getUMLElementType(nodeVISUALID);
            String semanticHint = null;
            if (type != null) {
                semanticHint = type.getSemanticHint();
            }
            EObjectAdapter elementAdapter = new EObjectAdapter((EObject)combinedFragment);
            CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, false, this.getDiagramPreferencesHint());
            CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
            createViewRequest.setLocation(location);
            Command command = this.getHost().getCommand((Request)createViewRequest);
            return new ICommandProxy((ICommand)new CommandProxyWithResult(command, (Object)descriptor));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    private Rectangle getExecutionSpecificationBounds(ExecutionSpecification es) {
        Point startLocation = null;
        Point finishLocation = null;
        Rectangle possibleStartLocations = null;
        Rectangle possibleFinishLocations = null;
        OccurrenceSpecification startEvent = es.getStart();
        OccurrenceSpecification finishEvent = es.getFinish();
        if (startEvent != null && finishEvent != null && this.getHost() instanceof LifelineEditPart) {
            int bottom;
            int top;
            LifelineEditPart hostLifeline = (LifelineEditPart)this.getHost();
            startLocation = SequenceUtil.findLocationOfEvent((LifelineEditPart)this.getHost(), (InteractionFragment)startEvent);
            if (startLocation == null) {
                possibleStartLocations = SequenceUtil.findPossibleLocationsForEvent(hostLifeline, startEvent);
            }
            if ((finishLocation = SequenceUtil.findLocationOfEvent(hostLifeline, (InteractionFragment)finishEvent)) == null) {
                possibleFinishLocations = SequenceUtil.findPossibleLocationsForEvent(hostLifeline, finishEvent);
            }
            if (startLocation == null) {
                if (finishLocation != null) {
                    top = possibleStartLocations.x;
                    bottom = possibleStartLocations.bottom();
                    if (top > finishLocation.y) {
                        return null;
                    }
                    startLocation = possibleStartLocations.getTop();
                    startLocation.y = (top + Math.min(bottom, finishLocation.y)) / 2;
                } else {
                    int topS = possibleStartLocations.y;
                    int bottomS = possibleStartLocations.bottom();
                    int topF = possibleFinishLocations.y;
                    int bottomF = possibleFinishLocations.bottom();
                    if (topS > bottomF) {
                        return null;
                    }
                    startLocation = possibleStartLocations.getTop();
                    finishLocation = possibleFinishLocations.getBottom();
                    if (bottomS < topF) {
                        startLocation.y = (topS + bottomS) / 2;
                        finishLocation.y = (topF + bottomF) / 2;
                    } else {
                        startLocation.y = (topS + bottomS + topS + topF) / 4;
                        finishLocation.y = (bottomF + topF + bottomF + bottomS) / 4;
                    }
                }
            }
            if (finishLocation == null) {
                top = possibleFinishLocations.y;
                bottom = possibleFinishLocations.bottom();
                if (bottom < startLocation.y) {
                    return null;
                }
                finishLocation = possibleFinishLocations.getBottom();
                finishLocation.y = (bottom + Math.max(top, startLocation.y)) / 2;
            }
            Rectangle result = new Rectangle(startLocation, finishLocation);
            result.width = 16;
            return result;
        }
        return null;
    }

    private Command dropMessage(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected Command getDropLocatedLinkCommand(DropObjectsRequest dropRequest, Element source, Element target, int linkVISUALID, Element semanticLink) {
        ICommand createCommand;
        GraphicalEditPart sourceEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        GraphicalEditPart targetEditPart = (GraphicalEditPart)this.lookForEditPart((EObject)target);
        CompositeCommand cc = new CompositeCommand("Drop");
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)this.getUMLElementType(linkVISUALID), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        SemanticAdapter sourceAdapter = null;
        SemanticAdapter targetAdapter = null;
        if (sourceEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkSourceDropLocation(dropRequest.getLocation(), source, target), (EObject)source);
            cc.add((IUndoableOperation)createCommand);
            sourceAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            sourceAdapter = new SemanticAdapter(null, sourceEditPart.getModel());
        }
        if (targetEditPart == null) {
            createCommand = this.getDefaultDropNodeCommand(this.getLinkTargetDropLocation(dropRequest.getLocation(), source, target), (EObject)target);
            cc.add((IUndoableOperation)createCommand);
            targetAdapter = (IAdaptable)createCommand.getCommandResult().getReturnValue();
        } else {
            targetAdapter = new SemanticAdapter(null, targetEditPart.getModel());
        }
        CreateLocatedConnectionViewCommand aLinkCommand = new CreateLocatedConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), (IAdaptable)sourceAdapter, (IAdaptable)targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        Point[] sourceAndTarget = this.getLinkSourceAndTargetLocations(semanticLink, sourceEditPart, targetEditPart);
        aLinkCommand.setLocations(sourceAndTarget[0], sourceAndTarget[1]);
        cc.compose((IUndoableOperation)aLinkCommand);
        return new ICommandProxy((ICommand)cc);
    }

    private Point[] getLinkSourceAndTargetLocations(Element semanticLink, GraphicalEditPart sourceEditPart, GraphicalEditPart targetEditPart) {
        Point[] sourceAndTarget = new Point[2];
        OccurrenceSpecification sourceEvent = null;
        OccurrenceSpecification targetEvent = null;
        if (semanticLink instanceof Message) {
            MessageEnd rcvEvent;
            MessageEnd sendEvent = ((Message)semanticLink).getSendEvent();
            if (sendEvent instanceof OccurrenceSpecification) {
                sourceEvent = (OccurrenceSpecification)sendEvent;
            }
            if ((rcvEvent = ((Message)semanticLink).getReceiveEvent()) instanceof OccurrenceSpecification) {
                targetEvent = (OccurrenceSpecification)rcvEvent;
            }
        } else if (semanticLink instanceof GeneralOrdering) {
            sourceEvent = ((GeneralOrdering)semanticLink).getBefore();
            targetEvent = ((GeneralOrdering)semanticLink).getAfter();
        }
        if (sourceEvent != null || targetEvent != null) {
            int bottomTarget;
            int centerTarget;
            Rectangle possibleSourceLocations = null;
            Rectangle possibleTargetLocations = null;
            if (sourceEvent != null && sourceEditPart instanceof LifelineEditPart) {
                sourceAndTarget[0] = SequenceUtil.findLocationOfEvent((LifelineEditPart)sourceEditPart, (InteractionFragment)sourceEvent);
                if (sourceAndTarget[0] == null) {
                    possibleSourceLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)sourceEditPart, sourceEvent);
                }
            }
            if (targetEvent != null && targetEditPart instanceof LifelineEditPart) {
                sourceAndTarget[1] = SequenceUtil.findLocationOfEvent((LifelineEditPart)targetEditPart, (InteractionFragment)targetEvent);
                if (sourceAndTarget[1] == null) {
                    possibleTargetLocations = SequenceUtil.findPossibleLocationsForEvent((LifelineEditPart)targetEditPart, targetEvent);
                }
            }
            if (sourceAndTarget[0] == null && possibleSourceLocations != null) {
                if (sourceAndTarget[1] == null && possibleTargetLocations == null) {
                    sourceAndTarget[0] = possibleSourceLocations.getCenter();
                } else if (sourceAndTarget[1] != null) {
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (sourceAndTarget[1].y < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                    } else if (centerSource <= sourceAndTarget[1].y) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = sourceAndTarget[1].y;
                    }
                } else {
                    centerTarget = possibleTargetLocations.getCenter().y;
                    bottomTarget = possibleTargetLocations.bottom();
                    int topSource = possibleSourceLocations.y;
                    int centerSource = possibleSourceLocations.getCenter().y;
                    if (bottomTarget < topSource) {
                        sourceAndTarget[0] = possibleSourceLocations.getTop();
                        sourceAndTarget[1] = possibleTargetLocations.getBottom();
                    } else if (centerSource <= centerTarget) {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    } else {
                        sourceAndTarget[0] = possibleSourceLocations.getCenter();
                        sourceAndTarget[0].y = (topSource + bottomTarget) / 2;
                        sourceAndTarget[1] = possibleTargetLocations.getCenter();
                        sourceAndTarget[1].y = (topSource + bottomTarget) / 2;
                    }
                }
            }
            if (sourceAndTarget[1] == null && possibleTargetLocations != null) {
                centerTarget = possibleTargetLocations.getCenter().y;
                bottomTarget = possibleTargetLocations.bottom();
                if (sourceAndTarget[0] == null) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else if (bottomTarget < sourceAndTarget[0].y) {
                    sourceAndTarget[1] = possibleTargetLocations.getBottom();
                } else if (sourceAndTarget[0].y <= centerTarget) {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                } else {
                    sourceAndTarget[1] = possibleTargetLocations.getCenter();
                    sourceAndTarget[1].y = sourceAndTarget[0].y;
                }
            }
        }
        return sourceAndTarget;
    }

    private Command dropGeneralOrdering(DropObjectsRequest dropRequest, Element semanticLink, int linkVISUALID) {
        Collection<?> sources = SequenceLinkMappingHelper.getInstance().getSource(semanticLink);
        Collection<?> targets = SequenceLinkMappingHelper.getInstance().getTarget(semanticLink);
        if (!sources.isEmpty() && !targets.isEmpty()) {
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            return this.getDropLocatedLinkCommand(dropRequest, source, target, linkVISUALID, semanticLink);
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }
}

