/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.navigator;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITreePathLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLParserProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.uml2.uml.ActionExecutionSpecification;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.ConsiderIgnoreFragment;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.Package;

public class UMLNavigatorLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
ITreePathLabelProvider {
    static {
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?UnknownElement", ImageDescriptor.getMissingImageDescriptor());
        UMLDiagramEditorPlugin.getInstance().getImageRegistry().put("Navigator?ImageNotFound", ImageDescriptor.getMissingImageDescriptor());
    }

    public void updateLabel(ViewerLabel label, TreePath elementPath) {
        Object element = elementPath.getLastSegment();
        if (element instanceof UMLNavigatorItem && !this.isOwnView(((UMLNavigatorItem)((Object)element)).getView())) {
            return;
        }
        label.setText(this.getText(element));
        label.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return UMLDiagramEditorPlugin.getInstance().getBundledImage(group.getIcon());
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return super.getImage(element);
            }
            return this.getImage(navigatorItem.getView());
        }
        return super.getImage(element);
    }

    public Image getImage(View view) {
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 4007: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Message", UMLElementTypes.Message_4007);
            }
            case 4003: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Message", UMLElementTypes.Message_4003);
            }
            case 3008: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?Constraint", UMLElementTypes.Constraint_3008);
            }
            case 3020: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?TimeObservation", UMLElementTypes.TimeObservation_3020);
            }
            case 3018: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?CombinedFragment", UMLElementTypes.CombinedFragment_3018);
            }
            case 4012: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?GeneralOrdering", UMLElementTypes.GeneralOrdering_4012);
            }
            case 3017: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?StateInvariant", UMLElementTypes.StateInvariant_3017);
            }
            case 3002: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?InteractionUse", UMLElementTypes.InteractionUse_3002);
            }
            case 3009: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?Comment", UMLElementTypes.Comment_3009);
            }
            case 4005: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Message", UMLElementTypes.Message_4005);
            }
            case 3021: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?DurationConstraint", UMLElementTypes.DurationConstraint_3021);
            }
            case 3019: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?TimeConstraint", UMLElementTypes.TimeConstraint_3019);
            }
            case 3007: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?ConsiderIgnoreFragment", UMLElementTypes.ConsiderIgnoreFragment_3007);
            }
            case 3016: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?Continuation", UMLElementTypes.Continuation_3016);
            }
            case 3001: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?Lifeline", UMLElementTypes.Lifeline_3001);
            }
            case 4006: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Message", UMLElementTypes.Message_4006);
            }
            case 3003: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?BehaviorExecutionSpecification", UMLElementTypes.BehaviorExecutionSpecification_3003);
            }
            case 3005: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?InteractionOperand", UMLElementTypes.InteractionOperand_3005);
            }
            case 4011: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Constraint?constrainedElement", UMLElementTypes.ConstraintConstrainedElement_4011);
            }
            case 4008: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Message", UMLElementTypes.Message_4008);
            }
            case 4009: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Message", UMLElementTypes.Message_4009);
            }
            case 3024: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?DurationObservation", UMLElementTypes.DurationObservation_3024);
            }
            case 1000: {
                return this.getImage("Navigator?Diagram?http://www.eclipse.org/uml2/4.0.0/UML?Package", UMLElementTypes.Package_1000);
            }
            case 4004: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Message", UMLElementTypes.Message_4004);
            }
            case 4010: {
                return this.getImage("Navigator?Link?http://www.eclipse.org/uml2/4.0.0/UML?Comment?annotatedElement", UMLElementTypes.CommentAnnotatedElement_4010);
            }
            case 3022: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?DestructionOccurrenceSpecification", UMLElementTypes.DestructionOccurrenceSpecification_3022);
            }
            case 2001: {
                return this.getImage("Navigator?TopLevelNode?http://www.eclipse.org/uml2/4.0.0/UML?Interaction", UMLElementTypes.Interaction_2001);
            }
            case 3006: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?ActionExecutionSpecification", UMLElementTypes.ActionExecutionSpecification_3006);
            }
            case 3023: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?DurationConstraint", UMLElementTypes.DurationConstraint_3023);
            }
            case 3004: {
                return this.getImage("Navigator?Node?http://www.eclipse.org/uml2/4.0.0/UML?CombinedFragment", UMLElementTypes.CombinedFragment_3004);
            }
        }
        return this.getImage("Navigator?UnknownElement", null);
    }

    private Image getImage(String key, IElementType elementType) {
        ImageRegistry imageRegistry = UMLDiagramEditorPlugin.getInstance().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null && elementType != null && UMLElementTypes.isKnownElementType(elementType)) {
            image = UMLElementTypes.getImage((IAdaptable)elementType);
            imageRegistry.put(key, image);
        }
        if (image == null) {
            image = imageRegistry.get("Navigator?ImageNotFound");
            imageRegistry.put(key, image);
        }
        return image;
    }

    public String getText(Object element) {
        if (element instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)element);
            return group.getGroupName();
        }
        if (element instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)element);
            if (!this.isOwnView(navigatorItem.getView())) {
                return null;
            }
            return this.getText(navigatorItem.getView());
        }
        return super.getText(element);
    }

    public String getText(View view) {
        if (view.getElement() != null && view.getElement().eIsProxy()) {
            return this.getUnresolvedDomainElementProxyText(view);
        }
        switch (UMLVisualIDRegistry.getVisualID(view)) {
            case 4007: {
                return this.getMessage_4007Text(view);
            }
            case 4003: {
                return this.getMessage_4003Text(view);
            }
            case 3008: {
                return this.getConstraint_3008Text(view);
            }
            case 3020: {
                return this.getTimeObservation_3020Text(view);
            }
            case 3018: {
                return this.getCombinedFragment_3018Text(view);
            }
            case 4012: {
                return this.getGeneralOrdering_4012Text(view);
            }
            case 3017: {
                return this.getStateInvariant_3017Text(view);
            }
            case 3002: {
                return this.getInteractionUse_3002Text(view);
            }
            case 3009: {
                return this.getComment_3009Text(view);
            }
            case 4005: {
                return this.getMessage_4005Text(view);
            }
            case 3021: {
                return this.getDurationConstraint_3021Text(view);
            }
            case 3019: {
                return this.getTimeConstraint_3019Text(view);
            }
            case 3007: {
                return this.getConsiderIgnoreFragment_3007Text(view);
            }
            case 3016: {
                return this.getContinuation_3016Text(view);
            }
            case 3001: {
                return this.getLifeline_3001Text(view);
            }
            case 4006: {
                return this.getMessage_4006Text(view);
            }
            case 3003: {
                return this.getBehaviorExecutionSpecification_3003Text(view);
            }
            case 3005: {
                return this.getInteractionOperand_3005Text(view);
            }
            case 4011: {
                return this.getConstraintConstrainedElement_4011Text(view);
            }
            case 4008: {
                return this.getMessage_4008Text(view);
            }
            case 4009: {
                return this.getMessage_4009Text(view);
            }
            case 3024: {
                return this.getDurationObservation_3024Text(view);
            }
            case 1000: {
                return this.getPackage_1000Text(view);
            }
            case 4004: {
                return this.getMessage_4004Text(view);
            }
            case 4010: {
                return this.getCommentAnnotatedElement_4010Text(view);
            }
            case 3022: {
                return this.getDestructionOccurrenceSpecification_3022Text(view);
            }
            case 2001: {
                return this.getInteraction_2001Text(view);
            }
            case 3006: {
                return this.getActionExecutionSpecification_3006Text(view);
            }
            case 3023: {
                return this.getDurationConstraint_3023Text(view);
            }
            case 3004: {
                return this.getCombinedFragment_3004Text(view);
            }
        }
        return this.getUnknownElementText(view);
    }

    private String getPackage_1000Text(View view) {
        Package domainModelElement = (Package)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 1000");
        return "";
    }

    private String getInteraction_2001Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Interaction_2001, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5001");
        return "";
    }

    private String getLifeline_3001Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Lifeline_3001, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5002");
        return "";
    }

    private String getBehaviorExecutionSpecification_3003Text(View view) {
        BehaviorExecutionSpecification domainModelElement = (BehaviorExecutionSpecification)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3003");
        return "";
    }

    private String getStateInvariant_3017Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.StateInvariant_3017, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5008));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5008");
        return "";
    }

    private String getCombinedFragment_3018Text(View view) {
        CombinedFragment domainModelElement = (CombinedFragment)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3018");
        return "";
    }

    private String getTimeConstraint_3019Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.TimeConstraint_3019, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5009));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5009");
        return "";
    }

    private String getTimeObservation_3020Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.TimeObservation_3020, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5010));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5010");
        return "";
    }

    private String getDurationConstraint_3021Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationConstraint_3021, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5011));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5011");
        return "";
    }

    private String getActionExecutionSpecification_3006Text(View view) {
        ActionExecutionSpecification domainModelElement = (ActionExecutionSpecification)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3006");
        return "";
    }

    private String getInteractionUse_3002Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.InteractionUse_3002, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5003");
        return "";
    }

    private String getCombinedFragment_3004Text(View view) {
        CombinedFragment domainModelElement = (CombinedFragment)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3004");
        return "";
    }

    private String getInteractionOperand_3005Text(View view) {
        InteractionOperand domainModelElement = (InteractionOperand)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3005");
        return "";
    }

    private String getContinuation_3016Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Continuation_3016, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5007));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5007");
        return "";
    }

    private String getConstraint_3008Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Constraint_3008, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5005));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5005");
        return "";
    }

    private String getComment_3009Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Comment_3009, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5006));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5006");
        return "";
    }

    private String getDurationConstraint_3023Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationConstraint_3023, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5018));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5018");
        return "";
    }

    private String getDurationObservation_3024Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.DurationObservation_3024, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(5016));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 5016");
        return "";
    }

    private String getConsiderIgnoreFragment_3007Text(View view) {
        ConsiderIgnoreFragment domainModelElement = (ConsiderIgnoreFragment)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3007");
        return "";
    }

    private String getMessage_4003Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_4003, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6001));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6001");
        return "";
    }

    private String getMessage_4004Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_4004, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6002));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6002");
        return "";
    }

    private String getMessage_4005Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_4005, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6003));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6003");
        return "";
    }

    private String getMessage_4006Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_4006, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6004));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6004");
        return "";
    }

    private String getMessage_4007Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_4007, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6005));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6005");
        return "";
    }

    private String getMessage_4008Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_4008, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6006));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6006");
        return "";
    }

    private String getMessage_4009Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.Message_4009, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6007));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6007");
        return "";
    }

    private String getCommentAnnotatedElement_4010Text(View view) {
        return "";
    }

    private String getDestructionOccurrenceSpecification_3022Text(View view) {
        DestructionOccurrenceSpecification domainModelElement = (DestructionOccurrenceSpecification)view.getElement();
        if (domainModelElement != null) {
            return String.valueOf(domainModelElement.getName());
        }
        UMLDiagramEditorPlugin.getInstance().logError("No domain element for view with visualID = 3022");
        return "";
    }

    private String getGeneralOrdering_4012Text(View view) {
        IParser parser = UMLParserProvider.getParser(UMLElementTypes.GeneralOrdering_4012, (EObject)(view.getElement() != null ? view.getElement() : view), UMLVisualIDRegistry.getType(6015));
        if (parser != null) {
            return parser.getPrintString((IAdaptable)new EObjectAdapter((EObject)(view.getElement() != null ? view.getElement() : view)), ParserOptions.NONE.intValue());
        }
        UMLDiagramEditorPlugin.getInstance().logError("Parser was not found for label 6015");
        return "";
    }

    private String getConstraintConstrainedElement_4011Text(View view) {
        return "";
    }

    private String getUnknownElementText(View view) {
        return "<UnknownElement Visual_ID = " + view.getType() + ">";
    }

    private String getUnresolvedDomainElementProxyText(View view) {
        return "<Unresolved domain element Visual_ID = " + view.getType() + ">";
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }
}

