/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.parser.custom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.uml.diagram.common.helper.DurationConstraintHelper;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.tools.utils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class TimeConstraintParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String LINE_BREAK = System.getProperty("line.separator");
    private static final String FORMAT = "{%s}";

    public TimeConstraintParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    public TimeConstraintParser(EAttribute[] features) {
        super(features);
    }

    public TimeConstraintParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    public String getPrintString(IAdaptable element, int flags) {
        Object adapter = element.getAdapter(EObject.class);
        if (adapter instanceof TimeConstraint) {
            TimeConstraint constraint = (TimeConstraint)adapter;
            ValueSpecification spec = constraint.getSpecification();
            return String.format(FORMAT, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec));
        }
        if (adapter instanceof DurationConstraint) {
            DurationConstraint constraint = (DurationConstraint)adapter;
            ValueSpecification spec = constraint.getSpecification();
            return String.format(FORMAT, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec));
        }
        if (adapter instanceof Message) {
            StringBuffer result = new StringBuffer();
            Message message = (Message)adapter;
            MessageEnd event1 = message.getSendEvent();
            MessageEnd event2 = message.getReceiveEvent();
            List constraints = DurationConstraintHelper.getDurationConstraintsBetween((NamedElement)event1, (NamedElement)event2);
            for (DurationConstraint constraint : constraints) {
                if (result.length() > 0) {
                    result.append(LINE_BREAK);
                }
                ValueSpecification spec = constraint.getSpecification();
                result.append(String.format(FORMAT, ValueSpecificationUtil.getSpecificationValue((ValueSpecification)spec)));
            }
            return result.toString();
        }
        return "";
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List getSemanticElementsBeingParsed(EObject element) {
        HashSet<Object> semanticElementsBeingParsed = new HashSet<Object>();
        if (element instanceof Constraint) {
            Constraint constraint = (Constraint)element;
            ValueSpecificationUtil.addEnclosedValueSpecificationToCollection((ValueSpecification)constraint.getSpecification(), semanticElementsBeingParsed);
        } else if (element instanceof Message) {
            Message message = (Message)element;
            semanticElementsBeingParsed.add(message);
            MessageEnd event1 = message.getSendEvent();
            semanticElementsBeingParsed.add(event1);
            MessageEnd event2 = message.getReceiveEvent();
            semanticElementsBeingParsed.add(event2);
            List constraints = DurationConstraintHelper.getDurationConstraintsBetween((NamedElement)event1, (NamedElement)event2);
            for (DurationConstraint constraint : constraints) {
                semanticElementsBeingParsed.add(constraint);
                semanticElementsBeingParsed.add(constraint.getOwner());
            }
        }
        return new ArrayList(semanticElementsBeingParsed);
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getConstraint_Specification().equals(feature) || ValueSpecification.class.isAssignableFrom(feature.getContainerClass());
    }
}

