/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.edit.part;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.common.figure.node.StereotypePropertiesCompartment;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.commands.CustomStateMachineResizeCommand;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.edit.parts.StateMachineNameEditPart;

public class CustomStateMachineNameEditPart
extends StateMachineNameEditPart {
    public CustomStateMachineNameEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("ConnectionHandlesPolicy");
        this.removeEditPolicy("PopupBarEditPolicy");
    }

    protected void handleNotificationEvent(Notification notification) {
        super.handleNotificationEvent(notification);
        this.refreshVisuals();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        int height = 0;
        int width = 0;
        for (IFigure current : this.getFigure().getParent().getChildren()) {
            if (!(current instanceof Label) && !(current instanceof WrappingLabel) && !(current instanceof StereotypePropertiesCompartment)) continue;
            Dimension d = current.getPreferredSize().getCopy();
            height += d.height;
            width = Math.max(width, d.width);
        }
        View stateMachineLabelView = (View)this.getModel();
        View stateMachineView = (View)stateMachineLabelView.eContainer();
        View stateMachineCompartView = (View)stateMachineView.getChildren().get(1);
        int stateMachineHeight = Zone.getHeight(stateMachineView);
        int stateMachineWidth = Zone.getWidth(stateMachineView);
        int stateMachineCompartHeight = Zone.getHeight(stateMachineCompartView);
        int dx = width - stateMachineWidth;
        int dy = stateMachineCompartHeight + height - stateMachineHeight;
        int x = Zone.getX(stateMachineView);
        int y = Zone.getY(stateMachineView);
        if (stateMachineHeight != -1 && width != 0 && dy != 0) {
            dx = dx > 0 ? dx : 0;
            SemanticAdapter adaptableForStateMachine = new SemanticAdapter(null, (Object)stateMachineView);
            ChangeBoundsRequest internalResizeRequest = new ChangeBoundsRequest();
            internalResizeRequest.setResizeDirection(16);
            internalResizeRequest.setSizeDelta(new Dimension(dx, dy));
            Rectangle rect = new Rectangle(x, y, stateMachineWidth + dx, stateMachineHeight + dy);
            CustomStateMachineResizeCommand internalResizeCommand = new CustomStateMachineResizeCommand((IAdaptable)adaptableForStateMachine, this.getDiagramPreferencesHint(), this.getEditingDomain(), DiagramUIMessages.CreateCommand_Label, internalResizeRequest, rect, true);
            internalResizeCommand.setOptions(Collections.singletonMap("unprotected", Boolean.TRUE));
            try {
                internalResizeCommand.execute(null, null);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }
}

