/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.importt.handlers;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.importt.messages.Messages;
import org.eclipse.papyrus.uml.profile.ui.dialogs.PackageImportTreeSelectionDialog;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

public class ImportPackageFromWorkspaceHandler
extends AbstractCommandHandler {
    protected Command getCommand() {
        return new ImportFromFileCommand((EditingDomain)this.getEditingDomain());
    }

    public class ImportFromFileCommand
    extends ChangeCommand {
        public ImportFromFileCommand(EditingDomain editingDomain) {
            super(editingDomain, new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    ResourceSelectionDialog chooseLib = new ResourceSelectionDialog(shell, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), Messages.ImportPackageFromFileHandler_SelectRegisteredModelLibrary);
                    chooseLib.open();
                    Object[] selection = chooseLib.getResult();
                    if (selection == null) {
                        return;
                    }
                    ResourceSet resourceSet = Util.getResourceSet((EObject)ImportPackageFromWorkspaceHandler.this.getSelectedElement());
                    int i = 0;
                    while (i < selection.length) {
                        if (selection[i] instanceof IFile) {
                            IFile currentFile = (IFile)selection[i];
                            URI modelUri = URI.createURI((String)("platform:/resource" + currentFile.getFullPath()));
                            Resource modelResource = resourceSet.getResource(modelUri, true);
                            PackageImportTreeSelectionDialog eisd = new PackageImportTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
                            int ret = eisd.open();
                            if (ret == 0) {
                                ArrayList result = eisd.getResult();
                                for (Element element : result) {
                                    PackageImport ei = UMLFactory.eINSTANCE.createPackageImport();
                                    ei.setImportedPackage((Package)element);
                                    ((Package)ImportPackageFromWorkspaceHandler.this.getSelectedElement()).getPackageImports().add((Object)ei);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }, "Import Libraries", "Import Libraries from Workspace");
        }

        public boolean canExecute() {
            if (ImportPackageFromWorkspaceHandler.this.getSelectedElements().size() == 1) {
                return ImportPackageFromWorkspaceHandler.this.getSelectedElement() instanceof Package;
            }
            return false;
        }
    }
}

