/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileTreeSelectionDialog
extends ElementImportTreeSelectionDialog {
    List<String> subProfilesList;

    public ProfileTreeSelectionDialog(Shell parent, Package model) {
        super(parent, model);
        this.subSelection = true;
        this.subProfilesList = new ArrayList<String>();
    }

    public ProfileTreeSelectionDialog(Shell parent, List<Package> model) {
        this(parent, model, new ArrayList<String>());
        this.subSelection = true;
    }

    public ProfileTreeSelectionDialog(Shell parent, List<Package> model, List<String> subprofiles) {
        super(parent, model);
        this.subSelection = true;
        this.subProfilesList = subprofiles;
    }

    @Override
    public ArrayList getResult() {
        ArrayList<Profile> profileList = new ArrayList<Profile>();
        for (Element currentElement : this.elementsToImport) {
            if (!(currentElement instanceof Profile)) continue;
            profileList.add((Profile)currentElement);
        }
        return profileList;
    }

    @Override
    protected void buildImportTreeList(TreeItem elemTree, Package _package) {
        for (Element elem : _package.getPackagedElements()) {
            TreeItem item;
            if (elem instanceof Profile) {
                item = new TreeItem(elemTree, 0);
                item.setText(((Package)elem).getName());
                item.setData((Object)elem);
                item.setImage(IMG_PROFILE);
                String name = ((Profile)elem).getQualifiedName();
                if (name != null && this.subProfilesList.contains(name)) {
                    item.setChecked(true);
                    this.elementsToImport.add(elem);
                }
                this.buildImportTreeList(item, (Package)elem);
                continue;
            }
            if (!(elem instanceof Package)) continue;
            item = new TreeItem(elemTree, 0);
            item.setText(((Package)elem).getName());
            item.setData((Object)elem);
            item.setImage(IMG_PACKAGE);
            this.buildImportTreeList(item, (Package)elem);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose profile(s) to apply");
    }
}

