/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.databinding;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.commands.AddMaskManagedLabelDisplayCommand;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetNameLabelIconCommand;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetQualifiedNameDepthCommand;
import org.eclipse.papyrus.infra.emf.appearance.commands.SetShadowFigureCommand;
import org.eclipse.papyrus.infra.emf.appearance.helper.NameLabelIconHelper;
import org.eclipse.papyrus.infra.emf.appearance.helper.QualifiedNameHelper;
import org.eclipse.papyrus.infra.emf.appearance.helper.ShadowFigureHelper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.tools.databinding.AbstractUMLAggregatedObservableValue;
import org.eclipse.papyrus.uml.tools.databinding.CommandBasedObservableValue;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Element;

public class ElementCustomizationObservableValue
extends AbstractUMLAggregatedObservableValue
implements CommandBasedObservableValue,
AggregatedObservable {
    private EditPart sourceElement;
    private Property property;
    private TransactionalEditingDomain domain;
    private View notationElement;
    private Element semanticElement;

    public ElementCustomizationObservableValue(EditPart sourceElement, Property property) {
        super(null);
        this.sourceElement = sourceElement;
        this.property = property;
        this.semanticElement = UMLUtil.resolveUMLElement((Object)sourceElement);
        this.notationElement = (View)sourceElement.getModel();
        this.domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((EObject)this.semanticElement);
    }

    public Object getValueType() {
        switch (this.property) {
            case LABEL_CUSTOMIZATION: 
            case QUALIFIED_NAME: {
                return Integer.class;
            }
            case ELEMENT_ICON: 
            case SHADOW: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    protected Object doGetValue() {
        switch (this.property) {
            case LABEL_CUSTOMIZATION: {
                return this.getEditPolicy().getCurrentDisplayValue();
            }
            case ELEMENT_ICON: {
                return NameLabelIconHelper.showLabelIcon((EModelElement)this.notationElement);
            }
            case SHADOW: {
                return ShadowFigureHelper.getShadowFigureValue((EModelElement)this.notationElement);
            }
            case QUALIFIED_NAME: {
                return QualifiedNameHelper.getQualifiedNameDepth((EModelElement)this.notationElement);
            }
        }
        return null;
    }

    protected IMaskManagedLabelEditPolicy getEditPolicy() {
        return (IMaskManagedLabelEditPolicy)this.sourceElement.getEditPolicy((Object)"MaskManagedLabelPolicy");
    }

    protected void doSetValue(Object value) {
        Command command = this.getCommand(value);
        this.domain.getCommandStack().execute(command);
    }

    public Command getCommand(Object value) {
        switch (this.property) {
            case ELEMENT_ICON: {
                if (value instanceof Boolean) {
                    return new SetNameLabelIconCommand(this.domain, (EModelElement)this.notationElement, ((Boolean)value).booleanValue());
                }
                Activator.log.warn(value + " is not a valid value for ElementIcon ; need a Boolean");
                break;
            }
            case SHADOW: {
                if (value instanceof Boolean) {
                    return new SetShadowFigureCommand(this.domain, (EModelElement)this.notationElement, ((Boolean)value).booleanValue());
                }
                Activator.log.warn(value + " is not a valid value for Shadow ; need a Boolean");
                break;
            }
            case QUALIFIED_NAME: {
                if (value instanceof Integer) {
                    return new SetQualifiedNameDepthCommand(this.domain, (EModelElement)this.notationElement, ((Integer)value).intValue());
                }
                Activator.log.warn(value + " is not a valid value for QualifiedNameDepth ; need an Integer");
                break;
            }
            case LABEL_CUSTOMIZATION: {
                if (value instanceof Integer) {
                    return new AddMaskManagedLabelDisplayCommand(this.domain, (EModelElement)this.notationElement, ((Integer)value).intValue());
                }
                Activator.log.warn(value + " is not a valid value for LabelCustomization ; need an Integer");
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        LABEL_CUSTOMIZATION,
        ELEMENT_ICON,
        SHADOW,
        QUALIFIED_NAME;

    }
}

