/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.emf.providers.EMFEnumeratorContentProvider;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.BooleanCombo;
import org.eclipse.papyrus.infra.widgets.editors.DoubleEditor;
import org.eclipse.papyrus.infra.widgets.editors.EnumCombo;
import org.eclipse.papyrus.infra.widgets.editors.FloatEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.editors.IntegerEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleIntegerEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleStringEditor;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableList;
import org.eclipse.papyrus.uml.tools.databinding.PapyrusObservableValue;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EStructuralFeatureEditor
implements IValueChangeListener,
IListChangeListener {
    protected PageBook pageBook;
    protected Composite currentPage;
    protected int style = 0;
    protected IStaticContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected ReferenceValueFactory valueFactory;
    protected IChangeListener changeListener;

    public EStructuralFeatureEditor(Composite parent, int style) {
        this.style = style;
        this.pageBook = new PageBook(parent, style);
        this.currentPage = this.createEmptyPage();
        this.pageBook.showPage((Control)this.currentPage);
    }

    public void setProviders(IStaticContentProvider contentProvider, ILabelProvider labelProvider) {
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
    }

    public void setValueFactory(ReferenceValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    public void setChangeListener(IChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    protected Composite createEmptyPage() {
        return new Composite((Composite)this.pageBook, this.style);
    }

    public void setFeatureToEdit(EStructuralFeature feature, EObject element) {
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        if (feature instanceof EReference) {
            MultipleReferenceEditor editor;
            if (feature.isMany()) {
                editor = new MultipleReferenceEditor((Composite)this.pageBook, this.style);
                this.setMultipleValueEditorProperties((MultipleValueEditor)editor, (List)element.eGet(feature), element, feature);
                editor.setProviders(this.contentProvider, this.labelProvider);
                editor.setFactory(this.valueFactory);
                this.currentPage = editor;
            } else {
                editor = new ReferenceDialog((Composite)this.pageBook, this.style);
                this.setValueEditorProperties((AbstractValueEditor)editor, element, feature);
                editor.setContentProvider(this.contentProvider);
                editor.setLabelProvider(this.labelProvider);
                editor.setValueFactory(this.valueFactory);
                editor.setDirectCreation(((EReference)feature).isContainment());
                this.currentPage = editor;
            }
        }
        if (feature instanceof EAttribute) {
            EClassifier type = feature.getEType();
            if (type instanceof EEnum) {
                if (!feature.isMany()) {
                    EnumCombo editor = new EnumCombo((Composite)this.pageBook, this.style);
                    this.setValueEditorProperties((AbstractValueEditor)editor, element, feature);
                    editor.setContentProvider((IStaticContentProvider)new EMFEnumeratorContentProvider(feature));
                    this.currentPage = editor;
                }
            } else if (type instanceof EDataType) {
                String instanceClassName = ((EDataType)type).getInstanceClassName();
                if ("java.lang.String".equalsIgnoreCase(instanceClassName) || "string".equalsIgnoreCase(instanceClassName)) {
                    if (feature.isMany()) {
                        MultipleStringEditor editor = new MultipleStringEditor((Composite)this.pageBook, this.style, true);
                        this.setMultipleValueEditorProperties((MultipleValueEditor)editor, (List)element.eGet(feature), element, feature);
                        this.currentPage = editor;
                    } else {
                        StringEditor editor = new StringEditor((Composite)this.pageBook, this.style | 2);
                        this.setValueEditorProperties((AbstractValueEditor)editor, element, feature);
                        this.currentPage = editor;
                    }
                } else if ("java.lang.Integer".equalsIgnoreCase(instanceClassName) || "integer".equalsIgnoreCase(instanceClassName) || "int".equalsIgnoreCase(instanceClassName)) {
                    if (feature.isMany()) {
                        MultipleIntegerEditor editor = new MultipleIntegerEditor((Composite)this.pageBook, this.style);
                        this.setMultipleValueEditorProperties((MultipleValueEditor)editor, (List)element.eGet(feature), element, feature);
                        this.currentPage = editor;
                    } else {
                        IntegerEditor editor = new IntegerEditor((Composite)this.pageBook, this.style);
                        this.setValueEditorProperties((AbstractValueEditor)editor, element, feature);
                        this.currentPage = editor;
                    }
                } else if ("java.lang.Boolean".equals(instanceClassName) || "boolean".equalsIgnoreCase(instanceClassName) || "bool".equalsIgnoreCase(instanceClassName)) {
                    if (!feature.isMany()) {
                        BooleanCombo editor = new BooleanCombo((Composite)this.pageBook, this.style);
                        this.setValueEditorProperties((AbstractValueEditor)editor, element, feature);
                        this.currentPage = editor;
                    }
                } else if ("java.lang.Float".equals(instanceClassName) || "float".equalsIgnoreCase(instanceClassName)) {
                    if (!feature.isMany()) {
                        FloatEditor editor = new FloatEditor((Composite)this.pageBook, this.style);
                        this.setValueEditorProperties((AbstractValueEditor)editor, element, feature);
                        this.currentPage = editor;
                    }
                } else if (("java.lang.Double".equals(instanceClassName) || "double".equalsIgnoreCase(instanceClassName)) && !feature.isMany()) {
                    DoubleEditor editor = new DoubleEditor((Composite)this.pageBook, this.style);
                    this.setValueEditorProperties((AbstractValueEditor)editor, element, feature);
                    this.currentPage = editor;
                }
            }
        }
        if (this.currentPage == null) {
            this.currentPage = this.createEmptyPage();
        }
        this.pageBook.showPage((Control)this.currentPage);
    }

    protected void setValueEditorProperties(AbstractValueEditor editor, EObject stereotypeApplication, EStructuralFeature feature) {
        editor.setLabel(feature.getName());
        if (feature.isDerived() || !feature.isChangeable()) {
            editor.setReadOnly(true);
        }
        PapyrusObservableValue observable = new PapyrusObservableValue(stereotypeApplication, feature, EMFHelper.resolveEditingDomain((EObject)stereotypeApplication));
        editor.setModelObservable((IObservableValue)observable);
        observable.addValueChangeListener((IValueChangeListener)this);
    }

    protected void setMultipleValueEditorProperties(MultipleValueEditor editor, List<?> initialList, EObject stereotypeApplication, EStructuralFeature feature) {
        editor.setLabel(feature.getName());
        editor.setUnique(feature.isUnique());
        editor.setOrdered(feature.isOrdered());
        if (feature instanceof EReference) {
            editor.setDirectCreation(((EReference)feature).isContainment());
        }
        if (feature.isDerived() || !feature.isChangeable()) {
            editor.setReadOnly(true);
        }
        PapyrusObservableList observable = new PapyrusObservableList(initialList, EMFHelper.resolveEditingDomain((EObject)stereotypeApplication), stereotypeApplication, feature);
        editor.setModelObservable((IObservableList)observable);
        editor.addCommitListener((ICommitListener)observable);
        observable.addListChangeListener((IListChangeListener)this);
    }

    public void setLayoutData(GridData data) {
        this.pageBook.setLayoutData((Object)data);
    }

    public void handleValueChange(ValueChangeEvent event) {
        if (this.changeListener != null) {
            this.changeListener.handleChange(new ChangeEvent(event.getObservable()));
        }
    }

    public void handleListChange(ListChangeEvent event) {
        if (this.changeListener != null) {
            this.changeListener.handleChange(new ChangeEvent(event.getObservable()));
        }
    }
}

