/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.widgets.editors.MultipleReferenceEditor;
import org.eclipse.papyrus.uml.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.papyrus.uml.properties.Activator;
import org.eclipse.papyrus.uml.properties.messages.Messages;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.FileSelectionFilter;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.FileSelectionValidator;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.Message;
import org.eclipse.papyrus.uml.properties.profile.ui.dialogs.RegisteredProfileSelectionDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class ProfileApplicationEditor
extends MultipleReferenceEditor {
    protected Button addRegisteredProfile;
    protected Package umlPackage;

    public ProfileApplicationEditor(Composite parent, int style) {
        super(parent, style);
    }

    protected void createListControls() {
        super.createListControls();
        this.up.dispose();
        this.down.dispose();
        this.edit.dispose();
        this.edit = null;
        this.down = null;
        this.up = null;
        this.add.setToolTipText(Messages.ProfileApplicationEditor_ApplyProfile);
        this.addRegisteredProfile = this.createButton(Activator.getDefault().getImage("/icons/AddReg.gif"), Messages.ProfileApplicationEditor_ApplyRegisteredProfile);
    }

    protected void addAction() {
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ArrayList<String> filetypes = new ArrayList<String>();
        filetypes.add("uml");
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(Messages.ProfileApplicationEditor_ApplyProfilesDialogTitle);
        dialog.setMessage(Messages.ProfileApplicationEditor_ApplyProfilesDialogDescription);
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.addFilter((ViewerFilter)new FileSelectionFilter(filetypes));
        dialog.setValidator((ISelectionStatusValidator)new FileSelectionValidator());
        dialog.setDoubleClickSelects(true);
        dialog.setHelpAvailable(false);
        dialog.setAllowMultiple(true);
        dialog.open();
        if (dialog.getResult() == null || dialog.getResult().length < 1) {
            return;
        }
        ArrayList<Package> importedModels = new ArrayList<Package>();
        int i = 0;
        while (i < dialog.getResult().length) {
            IFile selectedFile = (IFile)dialog.getResult()[i];
            URI profileUri = URI.createURI((String)("platform:/resource" + selectedFile.getFullPath().toString()));
            ResourceSet resourceSet = this.umlPackage.eResource().getResourceSet();
            Resource profileResource = resourceSet.getResource(profileUri, true);
            if (profileResource.getContents().get(0) instanceof Package) {
                Package importedModel = (Package)profileResource.getContents().get(0);
                importedModels.add(importedModel);
            }
            ++i;
        }
        if (importedModels.size() > 0) {
            ProfileTreeSelectionDialog profileDialog = new ProfileTreeSelectionDialog(this.getShell(), importedModels);
            profileDialog.open();
            ArrayList profilesToApply = profileDialog.getResult();
            Message message = new Message(Messages.ProfileApplicationEditor_WaitMessageTitle, Messages.ProfileApplicationEditor_WaitMessage);
            message.open();
            for (Profile profile : profilesToApply) {
                this.modelProperty.add((Object)profile);
            }
            message.close();
            this.commit();
        }
    }

    protected void addRegisteredAction() {
        RegisteredProfileSelectionDialog profileSelectionDialog = new RegisteredProfileSelectionDialog((Composite)this.getShell(), this.umlPackage);
        List<Profile> profilesToApply = profileSelectionDialog.run();
        for (Profile profile : profilesToApply) {
            this.modelProperty.add((Object)profile);
        }
        this.commit();
    }

    public void widgetSelected(SelectionEvent e) {
        super.widgetSelected(e);
        if (e.widget == this.addRegisteredProfile) {
            this.addRegisteredAction();
        }
    }

    public void setPackage(Package umlPackage) {
        this.umlPackage = umlPackage;
        this.updateControls();
    }

    protected void updateControls() {
        boolean enabled = this.modelProperty != null && this.umlPackage != null;
        this.add.setEnabled(enabled);
        this.addRegisteredProfile.setEnabled(enabled);
        this.remove.setEnabled(enabled);
    }
}

