/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.Collections;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.providers.EMFEnumeratorContentProvider;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.uml.tools.providers.InstanceValueContentProvider;
import org.eclipse.papyrus.uml.tools.providers.ServiceEditFilteredContentProvider;
import org.eclipse.papyrus.uml.tools.util.UMLProviderHelper;
import org.eclipse.papyrus.uml.tools.utils.ProfileUtil;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLContentProvider
extends EncapsulatedContentProvider {
    protected EObject eObject;
    protected EStructuralFeature feature;
    protected Stereotype stereotype;
    protected ResourceSet root;

    public UMLContentProvider(EObject source, EStructuralFeature feature) {
        this(source, feature, null);
    }

    public UMLContentProvider(EObject source, EStructuralFeature feature, Stereotype stereotype) {
        this(source, feature, stereotype, null);
    }

    public UMLContentProvider(EObject source, EStructuralFeature feature, Stereotype stereotype, ResourceSet root) {
        this.eObject = source;
        this.feature = feature;
        this.stereotype = stereotype;
        if (root == null && this.eObject.eResource() != null) {
            try {
                root = ServiceUtilsForResource.getInstance().getModelSet((Object)this.eObject.eResource());
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        if (root == null) {
            try {
                root = ServiceUtilsForActionHandlers.getInstance().getModelSet();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        this.root = root;
        IStructuredContentProvider semanticProvider = this.getSemanticProvider(source, feature, stereotype);
        this.encapsulated = UMLProviderHelper.encapsulateProvider(semanticProvider, this.eObject, feature, root);
    }

    protected IStructuredContentProvider getSemanticProvider(EObject source, EStructuralFeature feature, Stereotype stereotype) {
        Property umlReference;
        if (UMLUtil.getBaseElement((EObject)source) != null && (umlReference = ProfileUtil.findStereotypedProperty((Stereotype)stereotype, (String)feature.getName())) != null) {
            return this.getStereotypedReferenceContentProvider(source, feature, (Stereotype)umlReference.getType());
        }
        if (feature.getEType() instanceof EEnum) {
            return new EMFEnumeratorContentProvider(feature);
        }
        if (feature == UMLPackage.eINSTANCE.getPort_Provided() || feature == UMLPackage.eINSTANCE.getPort_Required()) {
            return new ServiceEditFilteredContentProvider(source, feature, this.root);
        }
        if (feature == UMLPackage.eINSTANCE.getInstanceValue_Instance()) {
            return new InstanceValueContentProvider((InstanceValue)source, feature, this.root);
        }
        return new ServiceEditFilteredContentProvider(source, feature, this.root);
    }

    protected IHierarchicContentProvider getStereotypedReferenceContentProvider(EObject source, EStructuralFeature feature, Stereotype type) {
        ResourceSet root = UMLUtil.getBaseElement((EObject)source).eResource().getResourceSet();
        ServiceEditFilteredContentProvider contentProvider = new ServiceEditFilteredContentProvider(source, feature, root);
        contentProvider.setWantedMetaclasses(Collections.singletonList(type));
        return contentProvider;
    }
}

