/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.xwt.core;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.papyrus.xwt.XWTException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operator {
    EQ,
    NE,
    GT,
    LT,
    GE,
    LE,
    LIKE,
    IS_A,
    IS_KIND_OF;


    public static boolean compare(Object operant1, Operator operator, Object operant2) throws XWTException {
        boolean result = false;
        switch (operator) {
            case EQ: {
                result = Operator.objectCompare(operant1, operant2);
                break;
            }
            case NE: {
                if (Operator.objectCompare(operant1, operant2)) break;
                result = true;
                break;
            }
            case GT: {
                if (Operator.numberCompare(operant1, operant2) != 1) break;
                return true;
            }
            case LT: {
                if (Operator.numberCompare(operant1, operant2) != -1) break;
                result = true;
                break;
            }
            case GE: {
                if (Operator.numberCompare(operant1, operant2) != 1 && Operator.numberCompare(operant1, operant2) != 0) break;
                result = true;
                break;
            }
            case LE: {
                if (Operator.numberCompare(operant1, operant2) != -1 && Operator.numberCompare(operant1, operant2) != 0) break;
                result = true;
                break;
            }
            case LIKE: {
                return Operator.LikeCompare(operant1, operant2);
            }
            case IS_A: {
                if (operant2 instanceof Class) {
                    return Operator.ISACompare(operant1, (Class)operant2);
                }
                throw new XWTException("type is not supported exception");
            }
            case IS_KIND_OF: {
                return Operator.isKindOfCompare(operant1, operant2);
            }
        }
        return result;
    }

    private static boolean isKindOfCompare(Object operant1, Object operant2) {
        return operant2.getClass().isInstance(operant1);
    }

    private static int numberCompare(Object operant1, Object operant2) throws XWTException {
        if (operant1 == null || operant2 == null) {
            throw new XWTException("the operant value is null exception");
        }
        Double longoperant1 = Operator.convertToDouble(operant1);
        Double longoperant2 = Operator.convertToDouble(operant2);
        return Operator.DoubleCompare(longoperant1, longoperant2);
    }

    private static Double convertToDouble(Object operant) throws XWTException {
        Character character;
        if (operant instanceof Double) {
            return (Double)operant;
        }
        if (operant instanceof Float) {
            Float floatvalue = (Float)operant;
            return Double.parseDouble(String.valueOf(floatvalue));
        }
        if (operant instanceof Integer) {
            Integer integer = (Integer)operant;
            return Double.parseDouble(String.valueOf(integer));
        }
        if (operant instanceof Character && Character.isDigit((character = (Character)operant).charValue())) {
            int numericValue = Character.getNumericValue(character.charValue());
            return Double.parseDouble(String.valueOf(numericValue));
        }
        if (operant instanceof Short) {
            Short shortvalue = (Short)operant;
            return Double.parseDouble(String.valueOf(shortvalue));
        }
        if (operant instanceof Byte) {
            Byte bytevalue = (Byte)operant;
            return Double.parseDouble(String.valueOf(bytevalue));
        }
        if (operant instanceof Long) {
            Long floatvalue = (Long)operant;
            return Double.parseDouble(String.valueOf(floatvalue));
        }
        if (operant instanceof BigDecimal) {
            BigDecimal bigdecimalvalue = (BigDecimal)operant;
            return Double.parseDouble(String.valueOf(bigdecimalvalue));
        }
        throw new XWTException("type is not supported exception");
    }

    private static boolean objectCompare(Object operant1, Object operant2) {
        if (operant1 == operant2) {
            return true;
        }
        if (operant1 != null) {
            return operant1.equals(operant2);
        }
        if (operant1 != null) {
            return operant2.equals(operant1);
        }
        return false;
    }

    private static boolean ISACompare(Object operant1, Class<?> clazz) {
        return clazz.isInstance(operant1);
    }

    private static int DoubleCompare(Double operant1, Double operant2) {
        return operant1.compareTo(operant2) < 0 ? -1 : (operant1.compareTo(operant2) == 0 ? 0 : 1);
    }

    private static boolean LikeCompare(Object operant1, Object operant2) throws XWTException {
        if (operant1 == null || operant2 == null) {
            throw new XWTException("the operant value is null exception");
        }
        if (operant1 instanceof String && operant2 instanceof String) {
            String operant1String = (String)operant1;
            String operant2String = (String)operant2;
            String queryString = Operator.parseRegularExpressionString(operant1String);
            Pattern pattern = Pattern.compile(queryString);
            Matcher matcher = pattern.matcher(operant2String);
            return matcher.find();
        }
        throw new XWTException("type is not supported exception");
    }

    public static String parseRegularExpressionString(String queryString) {
        String result = queryString;
        result = result.replace("?", ".");
        result = result.replace("*", ".*");
        return result;
    }
}

