/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
extends Statement {
    private final ASTNode.NodeList<Statement> statements = new ASTNode.NodeList(STATEMENTS_PROPERTY);
    private boolean isCurly;
    public static final ChildListPropertyDescriptor STATEMENTS_PROPERTY = new ChildListPropertyDescriptor(Block.class, "statements", Statement.class, true);
    public static final SimplePropertyDescriptor IS_CURLY_PROPERTY = new SimplePropertyDescriptor(Block.class, "isCurly", Boolean.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> properyList = new ArrayList<StructuralPropertyDescriptor>(2);
        properyList.add(STATEMENTS_PROPERTY);
        properyList.add(IS_CURLY_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    private Block(int start, int end, AST ast, Statement[] statements, boolean isCurly) {
        super(start, end, ast);
        if (statements == null) {
            throw new IllegalArgumentException();
        }
        this.setIsCurly(isCurly);
        int i = 0;
        while (i < statements.length) {
            this.statements.add(statements[i]);
            ++i;
        }
    }

    public Block(int start, int end, AST ast, List statements, boolean isCurly) {
        this(start, end, ast, statements == null ? null : statements.toArray(new Statement[statements.size()]), isCurly);
    }

    public Block(int start, int end, AST ast, List statements) {
        this(start, end, ast, statements, true);
    }

    public Block(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.statements) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<Block");
        this.appendInterval(buffer);
        buffer.append(" isCurly='").append(this.isCurly).append("'>\n");
        for (ASTNode aSTNode : this.statements) {
            aSTNode.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</Block>");
    }

    @Override
    public int getType() {
        return 6;
    }

    public boolean isCurly() {
        return this.isCurly;
    }

    public void setIsCurly(boolean isCurly) {
        this.preValueChange(IS_CURLY_PROPERTY);
        this.isCurly = isCurly;
        this.postValueChange(IS_CURLY_PROPERTY);
    }

    public Statement[] getStatements() {
        return this.statements.toArray((Statement[])new Statement[this.statements.size()]);
    }

    public List<Statement> statements() {
        return this.statements;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List statements = ASTNode.copySubtrees(target, this.statements());
        Block result = new Block(this.getStart(), this.getEnd(), target, statements, this.isCurly());
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == STATEMENTS_PROPERTY) {
            return this.statements();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    final boolean internalGetSetBooleanProperty(SimplePropertyDescriptor property, boolean get, boolean value) {
        if (property == IS_CURLY_PROPERTY) {
            if (get) {
                return this.isCurly();
            }
            this.setIsCurly(value);
            return false;
        }
        return super.internalGetSetBooleanProperty(property, get, value);
    }
}

