/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.NamespaceName;
import org.eclipse.php.internal.core.ast.nodes.SimplePropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullyQualifiedTraitMethodReference
extends Expression {
    private NamespaceName className;
    private String functionName;
    public static final ChildPropertyDescriptor CLASS_NAME = new ChildPropertyDescriptor(FullyQualifiedTraitMethodReference.class, "className", NamespaceName.class, true, true);
    public static final SimplePropertyDescriptor FUNCTION_NAME = new SimplePropertyDescriptor(FullyQualifiedTraitMethodReference.class, "functionName", String.class, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<StructuralPropertyDescriptor> propertyList = new ArrayList<StructuralPropertyDescriptor>(1);
        propertyList.add(CLASS_NAME);
        propertyList.add(FUNCTION_NAME);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public FullyQualifiedTraitMethodReference(int start, int end, AST ast, NamespaceName className, String functionName) {
        super(start, end, ast);
        this.className = className;
        this.functionName = functionName;
    }

    public FullyQualifiedTraitMethodReference(AST ast) {
        super(ast);
    }

    public NamespaceName getClassName() {
        return this.className;
    }

    public void setClassName(NamespaceName className) {
        if (className == null) {
            throw new IllegalArgumentException();
        }
        NamespaceName oldChild = this.className;
        this.preReplaceChild(oldChild, className, CLASS_NAME);
        this.className = className;
        this.postReplaceChild(oldChild, className, CLASS_NAME);
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        if (functionName == null) {
            throw new IllegalArgumentException();
        }
        this.preValueChange(FUNCTION_NAME);
        this.functionName = functionName;
        this.postValueChange(FUNCTION_NAME);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.className.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.className.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.className.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<FunctionName");
        this.appendInterval(buffer);
        buffer.append(" functionName='").append(this.functionName).append("'");
        buffer.append(">\n");
        this.className.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</FunctionName>");
    }

    @Override
    public int getType() {
        return 31;
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        NamespaceName className = ASTNode.copySubtree(target, this.getClassName());
        FullyQualifiedTraitMethodReference result = new FullyQualifiedTraitMethodReference(this.getStart(), this.getEnd(), target, className, this.functionName);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

