/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.ast.nodes.BindingResolver;
import org.eclipse.php.internal.core.ast.nodes.FunctionBinding;
import org.eclipse.php.internal.core.ast.nodes.IMethodBinding;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;

public class MethodBinding
extends FunctionBinding
implements IMethodBinding {
    private ITypeBinding declaringClassTypeBinding;

    public MethodBinding(BindingResolver resolver, IMethod modelElement) {
        super(resolver, modelElement);
    }

    public ITypeBinding getDeclaringClass() {
        IType parent;
        if (this.declaringClassTypeBinding == null && (parent = this.modelElement.getDeclaringType()) instanceof IType) {
            this.declaringClassTypeBinding = this.resolver.getTypeBinding(parent);
        }
        return this.declaringClassTypeBinding;
    }

    public boolean isConstructor() {
        try {
            return this.modelElement.isConstructor();
        }
        catch (ModelException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public boolean overrides(IMethodBinding method) {
        int otherModifiers;
        if (this.isConstructor() || method.isConstructor()) {
            return false;
        }
        if (this.getDeclaringClass().isSubTypeCompatible(method.getDeclaringClass()) && this.getName().equalsIgnoreCase(method.getName()) && ((otherModifiers = method.getModifiers()) & 4) == 0) {
            if ((otherModifiers & 0x10) != 0) {
                return false;
            }
            int thisModifiers = this.getModifiers();
            if ((otherModifiers & 0x40) != 0 || false) {
                return (thisModifiers & 0x40) != 0 || false;
            }
            if ((otherModifiers & 0x20) != 0) {
                return (thisModifiers & 0x20) != 0 || (thisModifiers & 0x40) != 0 || false;
            }
        }
        return false;
    }

    public ITypeBinding[] getReturnType() {
        return this.resolver.getMethodReturnTypeBinding(this.modelElement);
    }
}

