/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.TraitPrecedence;
import org.eclipse.php.internal.core.ast.nodes.TraitStatement;

public class TraitPrecedenceStatement
extends TraitStatement {
    private TraitPrecedence precedence;

    public TraitPrecedenceStatement(int start, int end, AST ast, TraitPrecedence precedence) {
        super(start, end, ast, precedence);
        this.precedence = precedence;
    }

    public TraitPrecedenceStatement(AST ast) {
        super(ast);
    }

    public TraitPrecedence getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(TraitPrecedence precedence) {
        this.setExp(precedence);
        this.precedence = precedence;
    }

    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        if (!(other instanceof TraitPrecedenceStatement)) {
            return false;
        }
        return super.subtreeMatch(matcher, other);
    }

    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<TraitPrecedenceStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.precedence.toString(buffer, "\t" + tab);
        buffer.append("\n");
        buffer.append(tab).append("</TraitPrecedenceStatement>");
    }

    ASTNode clone0(AST target) {
        TraitPrecedence precedence = ASTNode.copySubtree(target, this.getPrecedence());
        TraitPrecedenceStatement result = new TraitPrecedenceStatement(this.getStart(), this.getEnd(), target, precedence);
        return result;
    }
}

