/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.ast.match.ASTMatcher;
import org.eclipse.php.internal.core.ast.nodes.AST;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ChildListPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.nodes.UseStatementPart;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseStatement
extends Statement {
    private final ASTNode.NodeList<UseStatementPart> parts = new ASTNode.NodeList(PARTS_PROPERTY);
    public static final ChildListPropertyDescriptor PARTS_PROPERTY = new ChildListPropertyDescriptor(UseStatement.class, "parts", UseStatementPart.class, false);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildListPropertyDescriptor> properyList = new ArrayList<ChildListPropertyDescriptor>(1);
        properyList.add(PARTS_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(properyList);
    }

    public UseStatement(AST ast) {
        super(ast);
    }

    public UseStatement(int start, int end, AST ast, List parts) {
        super(start, end, ast);
        if (parts == null || parts.size() == 0) {
            throw new IllegalArgumentException();
        }
        Iterator it = parts.iterator();
        while (it.hasNext()) {
            this.parts.add((UseStatementPart)it.next());
        }
    }

    public UseStatement(int start, int end, AST ast, UseStatementPart[] parts) {
        super(start, end, ast);
        if (parts == null || parts.length == 0) {
            throw new IllegalArgumentException();
        }
        UseStatementPart[] useStatementPartArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            UseStatementPart part = useStatementPartArray[n2];
            this.parts.add(part);
            ++n2;
        }
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        for (ASTNode aSTNode : this.parts) {
            aSTNode.accept(visitor);
        }
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        for (ASTNode aSTNode : this.parts) {
            aSTNode.traverseTopDown(visitor);
        }
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        for (ASTNode aSTNode : this.parts) {
            aSTNode.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<UseStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        for (UseStatementPart part : this.parts) {
            part.toString(buffer, "\t" + tab);
            buffer.append("\n");
        }
        buffer.append(tab).append("</UseStatement>");
    }

    @Override
    public int getType() {
        return 67;
    }

    public List<UseStatementPart> parts() {
        return this.parts;
    }

    final List internalGetChildListProperty(ChildListPropertyDescriptor property) {
        if (property == PARTS_PROPERTY) {
            return this.parts();
        }
        return super.internalGetChildListProperty(property);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        List parts = ASTNode.copySubtrees(target, this.parts());
        UseStatement result = new UseStatement(this.getStart(), this.getEnd(), target, parts);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

