/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.ISourceModuleContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.PHPVersion;
import org.eclipse.php.internal.core.compiler.ast.nodes.ArrayVariableReference;
import org.eclipse.php.internal.core.compiler.ast.parser.ASTUtils;
import org.eclipse.php.internal.core.project.ProjectOptions;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPThisClassType;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferencer;
import org.eclipse.php.internal.core.typeinference.context.FileContext;
import org.eclipse.php.internal.core.typeinference.context.TypeContext;
import org.eclipse.php.internal.core.typeinference.goals.ClassVariableDeclarationGoal;
import org.eclipse.php.internal.core.typeinference.goals.MethodElementReturnTypeGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocClassVariableGoal;
import org.eclipse.php.internal.core.typeinference.goals.phpdoc.PHPDocMethodReturnTypeGoal;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;

public class CodeAssistUtils {
    public static final int USE_PHPDOC = 32;
    private static final String DOLLAR = "$";
    private static final String PAAMAYIM_NEKUDOTAIM = "::";
    protected static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final Pattern globalPattern = Pattern.compile("\\$GLOBALS[\\s]*\\[[\\s]*[\\'\\\"][\\w]+[\\'\\\"][\\s]*\\]");
    private static final IType[] EMPTY_TYPES = new IType[0];

    public static boolean startsWithIgnoreCase(String word, String prefix) {
        return word.toLowerCase().startsWith(prefix.toLowerCase());
    }

    public static IType[] getVariableType(IType[] types, String propertyName, int offset) {
        if (types != null) {
            IType[] iTypeArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                PHPDocClassVariableGoal phpDocGoal;
                IEvaluatedType evaluatedType;
                IType[] modelElements;
                IType type = iTypeArray[n2];
                PHPClassType classType = PHPClassType.fromIType(type);
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)type.getSourceModule(), null);
                FileContext fileContext = new FileContext(type.getSourceModule(), moduleDeclaration, offset);
                TypeContext typeContext = new TypeContext((ISourceModuleContext)fileContext, (IEvaluatedType)classType);
                PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
                if (!propertyName.startsWith(DOLLAR)) {
                    propertyName = DOLLAR + propertyName;
                }
                if ((modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType = typeInferencer.evaluateTypePHPDoc(phpDocGoal = new PHPDocClassVariableGoal(typeContext, propertyName), 3000), (ISourceModuleContext)fileContext, offset)) != null) {
                    return modelElements;
                }
                ClassVariableDeclarationGoal goal = new ClassVariableDeclarationGoal((IContext)typeContext, types, propertyName);
                evaluatedType = typeInferencer.evaluateType(goal);
                modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)fileContext, offset);
                if (modelElements != null) {
                    return modelElements;
                }
                ++n2;
            }
        }
        return EMPTY_TYPES;
    }

    public static IType[] getVariableType(ISourceModule sourceModule, String variableName, int position) {
        VariableReference varReference;
        ExpressionTypeGoal goal;
        PHPTypeInferencer typeInferencer;
        IEvaluatedType evaluatedType;
        IType[] modelElements;
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, position);
        if (context != null && (modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType = (typeInferencer = new PHPTypeInferencer()).evaluateType((AbstractTypeGoal)(goal = new ExpressionTypeGoal(context, (ASTNode)(varReference = CodeAssistUtils.getVariableReference(variableName, position))))), (ISourceModuleContext)context, position)) != null) {
            return modelElements;
        }
        return EMPTY_TYPES;
    }

    private static VariableReference getVariableReference(String variableName, int position) {
        String start = "";
        int arrayType = 0;
        if (variableName.endsWith("]")) {
            start = "[";
            arrayType = 1;
        } else if (variableName.endsWith("}")) {
            start = "{";
            arrayType = 2;
        }
        if (!"".equals(start)) {
            int startIndex = variableName.indexOf(start);
            String name = variableName.substring(0, startIndex);
            return new ArrayVariableReference(position, position + variableName.length(), name, null, arrayType);
        }
        return new VariableReference(position, position + variableName.length(), variableName);
    }

    public static IType[] getFunctionReturnType(IType[] types, String method, ISourceModule sourceModule, int offset) {
        return CodeAssistUtils.getFunctionReturnType(types, method, 32, sourceModule, offset);
    }

    public static IType[] getFunctionReturnType(IType[] types, String method, int mask, ISourceModule sourceModule, int offset) {
        PHPDocMethodReturnTypeGoal phpDocGoal;
        IEvaluatedType evaluatedType;
        IType[] modelElements;
        boolean usePhpDoc;
        PHPTypeInferencer typeInferencer = new PHPTypeInferencer();
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
        IContext context = ASTUtils.findContext(sourceModule, moduleDeclaration, offset);
        boolean bl = usePhpDoc = (mask & 0x20) != 0;
        if (usePhpDoc && (modelElements = PHPTypeInferenceUtils.getModelElements(evaluatedType = typeInferencer.evaluateTypePHPDoc(phpDocGoal = new PHPDocMethodReturnTypeGoal(context, types, method)), (ISourceModuleContext)context, offset)) != null) {
            return modelElements;
        }
        MethodElementReturnTypeGoal methodGoal = new MethodElementReturnTypeGoal(context, types, method);
        evaluatedType = typeInferencer.evaluateType(methodGoal);
        modelElements = evaluatedType instanceof PHPThisClassType && ((PHPThisClassType)evaluatedType).getType() != null ? new IType[]{((PHPThisClassType)evaluatedType).getType()} : PHPTypeInferenceUtils.getModelElements(evaluatedType, (ISourceModuleContext)context, offset);
        if (modelElements != null) {
            return modelElements;
        }
        return EMPTY_TYPES;
    }

    public static int getFunctionNameEndOffset(TextSequence statementText, int offset) {
        if (statementText.charAt(offset) != ')') {
            return 0;
        }
        int currChar = offset;
        int bracketsNum = 1;
        char inStringMode = '\u0000';
        while (bracketsNum != 0 && currChar >= 0) {
            char charAt;
            if ((charAt = statementText.charAt(--currChar)) == '\'' || charAt == '\"') {
                char c = inStringMode == '\u0000' ? charAt : (inStringMode = inStringMode == charAt ? (char)'\u0000' : inStringMode);
            }
            if (inStringMode != '\u0000') continue;
            if (charAt == ')') {
                ++bracketsNum;
                continue;
            }
            if (charAt != '(') continue;
            --bracketsNum;
        }
        return currChar;
    }

    public static IType getSelfClassData(ISourceModule sourceModule, int offset) {
        IType type = PHPModelUtils.getCurrentType(sourceModule, offset);
        IMethod method = PHPModelUtils.getCurrentMethod(sourceModule, offset);
        if (type != null && method != null) {
            try {
                int flags = type.getFlags();
                if (!(PHPFlags.isAbstract((int)flags) || PHPFlags.isInterface((int)flags) || PHPFlags.isInterface((int)flags))) {
                    return type;
                }
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
        }
        return null;
    }

    public static IType[] getTypesFor(ISourceModule sourceModule, TextSequence statementText, int endPosition, int offset) {
        endPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition);
        boolean isClassTriger = false;
        if (endPosition < 2) {
            return EMPTY_TYPES;
        }
        String triggerText = statementText.subSequence(endPosition - 2, endPosition).toString();
        if (!triggerText.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (triggerText.equals(PAAMAYIM_NEKUDOTAIM)) {
                isClassTriger = true;
            } else {
                return EMPTY_TYPES;
            }
        }
        int propertyEndPosition = PHPTextSequenceUtilities.readBackwardSpaces(statementText, endPosition - triggerText.length());
        int lastObjectOperator = PHPTextSequenceUtilities.getPrivousTriggerIndex(statementText, propertyEndPosition);
        String text = statementText.subSequence(0, propertyEndPosition).toString();
        if (lastObjectOperator == -1 || text.indexOf(62) >= 0 && text.indexOf(OBJECT_FUNCTIONS_TRIGGER) < 0) {
            return CodeAssistUtils.innerGetClassName(sourceModule, statementText, propertyEndPosition, isClassTriger, offset);
        }
        int propertyStartPosition = PHPTextSequenceUtilities.readForwardSpaces(statementText, lastObjectOperator + triggerText.length());
        String propertyName = statementText.subSequence(propertyStartPosition, propertyEndPosition).toString();
        IType[] types = CodeAssistUtils.getTypesFor(sourceModule, statementText, propertyStartPosition, offset);
        int bracketIndex = propertyName.indexOf(40);
        if (bracketIndex == -1) {
            return CodeAssistUtils.getVariableType(types, propertyName, offset);
        }
        String functionName = propertyName.substring(0, bracketIndex).trim();
        LinkedHashSet<IType> result = new LinkedHashSet<IType>();
        IType[] returnTypes = CodeAssistUtils.getFunctionReturnType(types, functionName, sourceModule, offset);
        if (returnTypes != null) {
            result.addAll(Arrays.asList(returnTypes));
        }
        return result.toArray(new IType[result.size()]);
    }

    private static IType[] innerGetClassName(ISourceModule sourceModule, TextSequence statementText, int propertyEndPosition, boolean isClassTriger, int offset) {
        String testedVar;
        PHPVersion phpVersion = ProjectOptions.getPhpVersion(sourceModule.getScriptProject().getProject());
        int classNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(phpVersion, statementText, propertyEndPosition, true);
        String className = statementText.subSequence(classNameStart, propertyEndPosition).toString();
        if (isClassTriger && className != null && className.length() != 0) {
            IType classData;
            if (("self".equals(className) || "parent".equals(className) || phpVersion.isGreaterThan(PHPVersion.PHP5) && "static".equals(className)) && (classData = PHPModelUtils.getCurrentType(sourceModule, offset - className.length() - 2)) != null) {
                return new IType[]{classData};
            }
            if (className.length() > 0) {
                if (className.startsWith(DOLLAR) && phpVersion.isGreaterThan(PHPVersion.PHP5)) {
                    int statementStart = statementText.getOriginalOffset(classNameStart);
                    return CodeAssistUtils.getVariableType(sourceModule, className, statementStart);
                }
                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule, null);
                FileContext context = new FileContext(sourceModule, moduleDeclaration, offset);
                PHPClassType type = PHPClassType.fromTypeName(className, sourceModule, offset);
                IType[] modelElements = PHPTypeInferenceUtils.getModelElements((IEvaluatedType)type, (ISourceModuleContext)context, offset);
                if (modelElements != null) {
                    return modelElements;
                }
                return EMPTY_TYPES;
            }
        }
        if (className.length() == 0 && (testedVar = statementText.subSequence(0, propertyEndPosition).toString().trim()) != null && testedVar.length() != 0) {
            Matcher m = globalPattern.matcher(testedVar);
            if (m.matches()) {
                String quotedVarName = testedVar.substring(testedVar.indexOf(91) + 1, testedVar.indexOf(93)).trim();
                className = DOLLAR + quotedVarName.substring(1, quotedVarName.length() - 1);
            } else if (testedVar.endsWith("}") || testedVar.endsWith("]")) {
                className = testedVar;
            }
        }
        if (className.length() > 0 && className.charAt(0) == '$') {
            int statementStart = statementText.getOriginalOffset(classNameStart);
            return CodeAssistUtils.getVariableType(sourceModule, className, statementStart);
        }
        if (propertyEndPosition > 0 && statementText.charAt(propertyEndPosition - 1) == ')') {
            int functionNameEnd = CodeAssistUtils.getFunctionNameEndOffset(statementText, propertyEndPosition - 1);
            int functionNameStart = PHPTextSequenceUtilities.readIdentifierStartIndex(phpVersion, statementText, functionNameEnd, false);
            String functionName = statementText.subSequence(functionNameStart, functionNameEnd).toString();
            LinkedHashSet<IType> returnTypes = new LinkedHashSet<IType>();
            IType[] types = CodeAssistUtils.getFunctionReturnType(null, functionName, sourceModule, offset);
            if (types != null) {
                returnTypes.addAll(Arrays.asList(types));
            }
            return returnTypes.toArray(new IType[returnTypes.size()]);
        }
        return EMPTY_TYPES;
    }

    public static boolean isClassFunctionCall(ISourceModule sourceModule, IType[] className, String functionName) {
        IType[] iTypeArray = className;
        int n = className.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                IMethod[] classMethod = PHPModelUtils.getTypeHierarchyMethod(type, functionName, true, null);
                if (classMethod != null) {
                    return true;
                }
            }
            catch (CoreException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        return false;
    }
}

